/*
 * Decompiled with CFR 0.152.
 */
package act.db.ebean;

import act.Act;
import act.app.App;
import act.app.event.SysEventId;
import act.app.event.SysEventListener;
import act.db.DbService;
import act.db.di.DaoInjectionListenerBase;
import act.db.ebean.EbeanDao;
import act.db.ebean.EbeanService;
import act.event.SysEventListenerBase;
import java.util.EventObject;
import java.util.List;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.inject.BeanSpec;
import org.osgl.util.Generics;

public class EbeanDaoInjectionListener
extends DaoInjectionListenerBase {
    public Class[] listenTo() {
        return new Class[]{EbeanDao.class};
    }

    public void onInjection(Object injectee, BeanSpec spec) {
        final EbeanDao dao = (EbeanDao)((Object)$.cast((Object)injectee));
        if (dao.ebeanServerProvided()) {
            return;
        }
        List typeParameters = spec.typeParams();
        if (typeParameters.isEmpty()) {
            typeParameters = Generics.typeParamImplementations((Class)spec.rawType(), EbeanDao.class);
        }
        if (null == typeParameters) {
            this.logger.warn("No type parameter information provided");
            return;
        }
        final Lang.T2 resolved = this.resolve(typeParameters);
        DbService dbService = App.instance().dbServiceManager().dbService((String)resolved._2);
        if (dbService instanceof EbeanService) {
            final EbeanService service = (EbeanService)((Object)$.cast((Object)dbService));
            Act.eventBus().bind(SysEventId.DB_SVC_LOADED, (SysEventListener)new SysEventListenerBase(){

                public void on(EventObject eventObject) throws Exception {
                    dao.ebean(service.ebean());
                    dao.modelType((Class)resolved._1);
                }
            });
        }
    }
}

