/*
 * Decompiled with CFR 0.152.
 */
package act.db.ebean.util;

import act.db.sql.DataSourceConfig;
import act.db.sql.SqlDbService;
import act.db.sql.SqlDbServiceConfig;
import act.db.sql.util.NamingConvention;
import com.avaje.ebean.config.MatchingNamingConvention;
import com.avaje.ebean.config.NamingConvention;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.UnderscoreNamingConvention;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Singleton;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.S;

@Singleton
public class EbeanConfigAdaptor {
    private static final Logger LOGGER = LogManager.get(EbeanConfigAdaptor.class);

    public ServerConfig adaptFrom(SqlDbServiceConfig actConfig, DataSourceConfig dsConfig, SqlDbService svc) {
        ServerConfig config = new ServerConfig();
        config.setName(svc.id());
        config.setDataSourceConfig(this.adaptFrom(dsConfig, svc));
        config.setDdlGenerate(actConfig.ddlGeneratorConfig.create);
        config.setDdlRun(actConfig.ddlGeneratorConfig.create);
        config.setDdlCreateOnly(!actConfig.ddlGeneratorConfig.drop);
        config.setNamingConvention(this.namingConvention(actConfig));
        Set modelClasses = svc.entityClasses();
        if (null != modelClasses && !modelClasses.isEmpty()) {
            for (Class modelClass : modelClasses) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(S.concat((String)"add model class into Ebean config: ", (String)modelClass.getName()));
                }
                config.addClass(modelClass);
            }
        }
        config.setDisableClasspathSearch(true);
        return config;
    }

    public org.avaje.datasource.DataSourceConfig adaptFrom(DataSourceConfig actConfig, SqlDbService svc) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)actConfig.customProperties);
        org.avaje.datasource.DataSourceConfig config = new org.avaje.datasource.DataSourceConfig();
        config.loadSettings(properties, svc.id());
        config.setUrl(actConfig.url);
        config.setDriver(actConfig.driver);
        config.setUsername(actConfig.username);
        config.setPassword(actConfig.password);
        config.setAutoCommit(actConfig.autoCommit);
        config.setMinConnections(actConfig.minConnections);
        config.setMaxConnections(actConfig.maxConnections);
        config.setHeartbeatSql(actConfig.heartbeatSql);
        config.setIsolationLevel(actConfig.isolationLevel);
        config.setMaxAgeMinutes(actConfig.maxAgeMinutes);
        config.setMaxInactiveTimeSecs(actConfig.maxInactiveTimeSecs);
        config.setHeartbeatFreqSecs(actConfig.heartbeatFreqSecs);
        config.setCstmtCacheSize(actConfig.cstmtCacheSize);
        config.setPstmtCacheSize(actConfig.pstmtCacheSize);
        config.setTrimPoolFreqSecs(actConfig.trimPoolFreqSecs);
        config.setWaitTimeoutMillis(actConfig.waitTimeoutMillis);
        config.setLeakTimeMinutes(actConfig.leakTimeMinutes);
        config.setPoolListener(actConfig.poolListener);
        config.setOffline(actConfig.offline);
        config.setCaptureStackTrace(actConfig.captureStackTrace);
        return config;
    }

    private NamingConvention namingConvention(SqlDbServiceConfig svcConfig) {
        if (!svcConfig.rawConf.containsKey("naming.convention")) {
            return new UnderscoreNamingConvention();
        }
        if (NamingConvention.Default.MATCHING == svcConfig.tableNamingConvention) {
            return new MatchingNamingConvention();
        }
        return new UnderscoreNamingConvention();
    }
}

