/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Distinct;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;

public class DistinctExample {
    public static void main(String[] args) throws Exception {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)p.apply("ReadLines", (PTransform)TextIO.read().from(options.getInput()))).apply((PTransform)Distinct.create())).apply("DedupedShakespeare", (PTransform)TextIO.write().to(options.getOutput()));
        p.run().waitUntilFinish();
    }

    public static interface Options
    extends PipelineOptions {
        @Description(value="Path to the directory or GCS prefix containing files to read from")
        @Default.String(value="gs://apache-beam-samples/shakespeare/*")
        public String getInput();

        public void setInput(String var1);

        @Description(value="Path of the file to write to")
        @Default.InstanceFactory(value=OutputFactory.class)
        public String getOutput();

        public void setOutput(String var1);

        public static class OutputFactory
        implements DefaultValueFactory<String> {
            public String create(PipelineOptions options) {
                if (options.getTempLocation() != null) {
                    return GcsPath.fromUri((String)options.getTempLocation()).resolve("deduped.txt").toString();
                }
                throw new IllegalArgumentException("Must specify --output or --tempLocation");
            }
        }
    }
}

