/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.subprocess;

import org.apache.beam.examples.subprocess.configuration.SubProcessConfiguration;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.Validation;

public interface SubProcessPipelineOptions
extends PipelineOptions {
    @Description(value="Source GCS directory where the C++ library is located gs://bucket/tests")
    @Validation.Required
    public String getSourcePath();

    public void setSourcePath(String var1);

    @Description(value="Working directory for the process I/O")
    @Default.String(value="/tmp/grid_working_files")
    public String getWorkerPath();

    public void setWorkerPath(String var1);

    @Description(value="The maximum time to wait for the sub-process to complete")
    @Default.Integer(value=3600)
    public Integer getWaitTime();

    public void setWaitTime(Integer var1);

    @Description(value="As sub-processes can be heavy weight define the level of concurrency level")
    @Validation.Required
    public Integer getConcurrency();

    public void setConcurrency(Integer var1);

    @Description(value="Should log files only be uploaded if error.")
    @Default.Boolean(value=true)
    public Boolean getOnlyUpLoadLogsOnError();

    public void setOnlyUpLoadLogsOnError(Boolean var1);

    @Default.InstanceFactory(value=SubProcessConfigurationFactory.class)
    public SubProcessConfiguration getSubProcessConfiguration();

    public void setSubProcessConfiguration(SubProcessConfiguration var1);

    public static class SubProcessConfigurationFactory
    implements DefaultValueFactory<SubProcessConfiguration> {
        public SubProcessConfiguration create(PipelineOptions options) {
            SubProcessPipelineOptions subProcessPipelineOptions = (SubProcessPipelineOptions)options;
            SubProcessConfiguration configuration = new SubProcessConfiguration();
            if (subProcessPipelineOptions.getSourcePath() == null) {
                throw new IllegalStateException("Source path must be set");
            }
            if (subProcessPipelineOptions.getConcurrency() == null || subProcessPipelineOptions.getConcurrency() == 0) {
                throw new IllegalStateException("Concurrency must be set and be > 0");
            }
            configuration.setSourcePath(subProcessPipelineOptions.getSourcePath());
            configuration.setWorkerPath(subProcessPipelineOptions.getWorkerPath());
            configuration.setWaitTime(subProcessPipelineOptions.getWaitTime());
            configuration.setOnlyUpLoadLogsOnError(subProcessPipelineOptions.getOnlyUpLoadLogsOnError());
            configuration.concurrency = subProcessPipelineOptions.getConcurrency();
            return configuration;
        }
    }
}

