/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.subprocess.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.beam.examples.subprocess.configuration.SubProcessConfiguration;
import org.apache.beam.examples.subprocess.utils.ExecutableFile;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);

    public static ResourceId getFileResourceId(String directory, String fileName) {
        ResourceId resourceID = FileSystems.matchNewResource((String)directory, (boolean)true);
        return resourceID.getCurrentDirectory().resolve(fileName, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
    }

    public static String toStringParams(ProcessBuilder builder) {
        return String.join((CharSequence)",", builder.command());
    }

    public static String copyFileFromWorkerToGCS(SubProcessConfiguration configuration, Path fileToUpload) throws Exception {
        Path fileName = fileToUpload.getFileName();
        if (fileName == null) {
            throw new IllegalArgumentException("FileName can not be null.");
        }
        ResourceId sourceFile = FileUtils.getFileResourceId(configuration.getWorkerPath(), fileName.toString());
        LOG.info("Copying file from worker " + sourceFile);
        ResourceId destinationFile = FileUtils.getFileResourceId(configuration.getSourcePath(), fileName.toString());
        try {
            return FileUtils.copyFile(sourceFile, destinationFile);
        }
        catch (Exception ex) {
            LOG.error(String.format("Error copying file from %s  to %s", sourceFile, destinationFile), (Throwable)ex);
            throw ex;
        }
    }

    public static String copyFileFromGCSToWorker(ExecutableFile execuableFile) throws Exception {
        ResourceId sourceFile = FileSystems.matchNewResource((String)execuableFile.getSourceGCSLocation(), (boolean)false);
        ResourceId destinationFile = FileSystems.matchNewResource((String)execuableFile.getDestinationLocation(), (boolean)false);
        try {
            LOG.info(String.format("Moving File %s to %s ", execuableFile.getSourceGCSLocation(), execuableFile.getDestinationLocation()));
            Path path = Paths.get(execuableFile.getDestinationLocation(), new String[0]);
            if (path.toFile().exists()) {
                LOG.warn(String.format("Overwriting file %s, should only see this once per worker.", execuableFile.getDestinationLocation()));
            }
            FileUtils.copyFile(sourceFile, destinationFile);
            path.toFile().setExecutable(true);
            return path.toString();
        }
        catch (Exception ex) {
            LOG.error(String.format("Error moving file : %s ", execuableFile.fileName), (Throwable)ex);
            throw ex;
        }
    }

    public static String copyFile(ResourceId sourceFile, ResourceId destinationFile) throws IOException {
        try (WritableByteChannel writeChannel = FileSystems.create((ResourceId)destinationFile, (String)"text/plain");
             ReadableByteChannel readChannel = FileSystems.open((ResourceId)sourceFile);){
            ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
            while (readChannel.read(buffer) != -1) {
                buffer.flip();
                writeChannel.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                writeChannel.write(buffer);
            }
        }
        return destinationFile.toString();
    }

    public static void createDirectoriesOnWorker(SubProcessConfiguration configuration) throws IOException {
        try {
            Path path = Paths.get(configuration.getWorkerPath(), new String[0]);
            if (!path.toFile().exists()) {
                Files.createDirectories(path, new FileAttribute[0]);
                LOG.info(String.format("Created Folder %s ", path.toFile()));
            }
        }
        catch (FileAlreadyExistsException ex) {
            LOG.warn(String.format(" Tried to create folder %s which already existsed, this should not happen!", configuration.getWorkerPath()), (Throwable)ex);
        }
    }

    public static String readLineOfLogFile(Path path) {
        String string;
        block8: {
            BufferedReader br = Files.newBufferedReader(Paths.get(path.toString(), new String[0]), StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                string = br.readLine();
                if (br == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (br != null) {
                            FileUtils.$closeResource(throwable, br);
                        }
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    LOG.error("Error reading the first line of file", (Throwable)e);
                    return "";
                }
            }
            FileUtils.$closeResource(throwable, br);
        }
        return string;
    }
}

