/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.beam.examples.DebuggingWordCount;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.Files;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DebuggingWordCountTest {
    @Rule
    public @UnknownKeyFor @NonNull @Initialized TemporaryFolder tmpFolder = new TemporaryFolder();

    private @UnknownKeyFor @NonNull @Initialized String getFilePath(@UnknownKeyFor @NonNull @Initialized String filePath) {
        if (filePath.contains(":")) {
            return filePath.replace("\\", "/").split(":", -1)[1];
        }
        return filePath;
    }

    @Test
    public void testDebuggingWordCount() throws @UnknownKeyFor @NonNull @Initialized Exception {
        File inputFile = this.tmpFolder.newFile();
        File outputFile = this.tmpFolder.newFile();
        Files.write((CharSequence)"stomach secret Flourish message Flourish here Flourish", (File)inputFile, (Charset)StandardCharsets.UTF_8);
        DebuggingWordCount.WordCountOptions options = (DebuggingWordCount.WordCountOptions)TestPipeline.testingPipelineOptions().as(DebuggingWordCount.WordCountOptions.class);
        options.setInputFile(this.getFilePath(inputFile.getAbsolutePath()));
        options.setOutput(this.getFilePath(outputFile.getAbsolutePath()));
        DebuggingWordCount.runDebuggingWordCount((DebuggingWordCount.WordCountOptions)options);
    }
}

