/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import org.apache.beam.examples.cookbook.BigQueryTornadoes;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.testing.BigqueryMatcher;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryTornadoesIT {
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_OUTPUT_CHECKSUM = "1ab4c7ec460b94bbb3c3885b178bf0e6bed56e1f";

    @BeforeClass
    public static void setUp() {
        PipelineOptionsFactory.register(BigQueryTornadoesITOptions.class);
    }

    private void runE2EBigQueryTornadoesTest(@UnknownKeyFor @NonNull @Initialized BigQueryTornadoesITOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        String query = String.format("SELECT month, tornado_count FROM [%s]", options.getOutput());
        BigQueryTornadoes.runBigQueryTornadoes((BigQueryTornadoes.Options)options);
        MatcherAssert.assertThat((Object)BigqueryMatcher.createQuery((String)options.getAppName(), (String)options.getProject(), (String)query), (Matcher)BigqueryMatcher.queryResultHasChecksum((String)DEFAULT_OUTPUT_CHECKSUM));
    }

    @Test
    public void testE2EBigQueryTornadoesWithExport() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigQueryTornadoesITOptions options = (BigQueryTornadoesITOptions)TestPipeline.testingPipelineOptions().as(BigQueryTornadoesITOptions.class);
        options.setReadMethod(BigQueryIO.TypedRead.Method.EXPORT);
        options.setOutput(String.format("%s.%s", "BigQueryTornadoesIT", "monthly_tornadoes_" + System.currentTimeMillis()));
        this.runE2EBigQueryTornadoesTest(options);
    }

    @Test
    public void testE2eBigQueryTornadoesWithStorageApi() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigQueryTornadoesITOptions options = (BigQueryTornadoesITOptions)TestPipeline.testingPipelineOptions().as(BigQueryTornadoesITOptions.class);
        options.setReadMethod(BigQueryIO.TypedRead.Method.DIRECT_READ);
        options.setOutput(String.format("%s.%s", "BigQueryTornadoesIT", "monthly_tornadoes_storage_" + System.currentTimeMillis()));
        this.runE2EBigQueryTornadoesTest(options);
    }

    @Test
    public void testE2EBigQueryTornadoesWithExportUsingQuery() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigQueryTornadoesITOptions options = (BigQueryTornadoesITOptions)TestPipeline.testingPipelineOptions().as(BigQueryTornadoesITOptions.class);
        options.setReadMethod(BigQueryIO.TypedRead.Method.EXPORT);
        options.setOutput(String.format("%s.%s", "BigQueryTornadoesIT", "monthly_tornadoes_" + System.currentTimeMillis()));
        options.setInputQuery("SELECT * FROM `clouddataflow-readonly.samples.weather_stations`");
        this.runE2EBigQueryTornadoesTest(options);
    }

    @Test
    public void testE2eBigQueryTornadoesWithStorageApiUsingQuery() throws @UnknownKeyFor @NonNull @Initialized Exception {
        BigQueryTornadoesITOptions options = (BigQueryTornadoesITOptions)TestPipeline.testingPipelineOptions().as(BigQueryTornadoesITOptions.class);
        options.setReadMethod(BigQueryIO.TypedRead.Method.DIRECT_READ);
        options.setOutput(String.format("%s.%s", "BigQueryTornadoesIT", "monthly_tornadoes_storage_" + System.currentTimeMillis()));
        options.setInputQuery("SELECT * FROM `clouddataflow-readonly.samples.weather_stations`");
        this.runE2EBigQueryTornadoesTest(options);
    }

    public static interface BigQueryTornadoesITOptions
    extends TestPipelineOptions,
    BigQueryTornadoes.Options,
    BigQueryOptions {
    }
}

