/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.examples.cookbook.BigQueryTornadoes;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryTornadoesTest {
    @Rule
    public @UnknownKeyFor @NonNull @Initialized TestPipeline p = TestPipeline.create();

    @Test
    @Category(value={ValidatesRunner.class})
    public void testExtractTornadoes() {
        TableRow row = new TableRow().set("month", (Object)"6").set("tornado", (Object)true);
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of((Iterable)ImmutableList.of((Object)row)));
        PCollection result = (PCollection)input.apply((PTransform)ParDo.of((DoFn)new BigQueryTornadoes.ExtractTornadoesFn()));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new Integer[]{6});
        this.p.run().waitUntilFinish();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testNoTornadoes() {
        TableRow row = new TableRow().set("month", (Object)6).set("tornado", (Object)false);
        PCollection inputs = (PCollection)this.p.apply((PTransform)Create.of((Iterable)ImmutableList.of((Object)row)));
        PCollection result = (PCollection)inputs.apply((PTransform)ParDo.of((DoFn)new BigQueryTornadoes.ExtractTornadoesFn()));
        PAssert.that((PCollection)result).empty();
        this.p.run().waitUntilFinish();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testEmpty() {
        PCollection inputs = (PCollection)this.p.apply((PTransform)Create.empty((TypeDescriptor)new TypeDescriptor<KV<Integer, Long>>(){}));
        PCollection result = (PCollection)inputs.apply((PTransform)ParDo.of((DoFn)new BigQueryTornadoes.FormatCountsFn()));
        PAssert.that((PCollection)result).empty();
        this.p.run().waitUntilFinish();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFormatCounts() {
        PCollection inputs = (PCollection)this.p.apply((PTransform)Create.of((Object)KV.of((Object)3, (Object)0L), (Object[])new KV[]{KV.of((Object)4, (Object)Long.MAX_VALUE), KV.of((Object)5, (Object)Long.MIN_VALUE)}));
        PCollection result = (PCollection)inputs.apply((PTransform)ParDo.of((DoFn)new BigQueryTornadoes.FormatCountsFn()));
        PAssert.that((PCollection)result).containsInAnyOrder((Object[])new TableRow[]{new TableRow().set("month", (Object)3).set("tornado_count", (Object)0), new TableRow().set("month", (Object)4).set("tornado_count", (Object)Long.MAX_VALUE), new TableRow().set("month", (Object)5).set("tornado_count", (Object)Long.MIN_VALUE)});
        this.p.run().waitUntilFinish();
    }
}

