/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableRow;
import java.util.List;
import org.apache.beam.examples.cookbook.CombinePerKeyExamples;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CombinePerKeyExamplesTest {
    private static final @UnknownKeyFor @NonNull @Initialized TableRow row1 = new TableRow().set("corpus", (Object)"king_lear").set("word", (Object)"snuffleupaguses");
    private static final @UnknownKeyFor @NonNull @Initialized TableRow row2 = new TableRow().set("corpus", (Object)"macbeth").set("word", (Object)"antidisestablishmentarianism");
    private static final @UnknownKeyFor @NonNull @Initialized TableRow row3 = new TableRow().set("corpus", (Object)"king_lear").set("word", (Object)"antidisestablishmentarianism");
    private static final @UnknownKeyFor @NonNull @Initialized TableRow row4 = new TableRow().set("corpus", (Object)"macbeth").set("word", (Object)"bob");
    private static final @UnknownKeyFor @NonNull @Initialized TableRow row5 = new TableRow().set("corpus", (Object)"king_lear").set("word", (Object)"hi");
    static final @UnknownKeyFor @NonNull @Initialized TableRow @UnknownKeyFor @NonNull @Initialized [] ROWS_ARRAY = new TableRow[]{row1, row2, row3, row4, row5};
    private static final @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> tuple1 = KV.of((Object)"snuffleupaguses", (Object)"king_lear");
    private static final @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> tuple2 = KV.of((Object)"antidisestablishmentarianism", (Object)"macbeth");
    private static final @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> tuple3 = KV.of((Object)"antidisestablishmentarianism", (Object)"king_lear");
    private static final @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> combinedTuple1 = KV.of((Object)"antidisestablishmentarianism", (Object)"king_lear,macbeth");
    private static final @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> combinedTuple2 = KV.of((Object)"snuffleupaguses", (Object)"king_lear");
    static final @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> @UnknownKeyFor @NonNull @Initialized [] COMBINED_TUPLES_ARRAY = new KV[]{combinedTuple1, combinedTuple2};
    private static final @UnknownKeyFor @NonNull @Initialized TableRow resultRow1 = new TableRow().set("word", (Object)"snuffleupaguses").set("all_plays", (Object)"king_lear");
    private static final @UnknownKeyFor @NonNull @Initialized TableRow resultRow2 = new TableRow().set("word", (Object)"antidisestablishmentarianism").set("all_plays", (Object)"king_lear,macbeth");

    @Test
    public void testExtractLargeWordsFn() throws @UnknownKeyFor @NonNull @Initialized Exception {
        DoFnTester extractLargeWordsFn = DoFnTester.of((DoFn)new CombinePerKeyExamples.ExtractLargeWordsFn());
        List results = extractLargeWordsFn.processBundle((Object[])ROWS_ARRAY);
        MatcherAssert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem(tuple1));
        MatcherAssert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem(tuple2));
        MatcherAssert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem(tuple3));
    }

    @Test
    public void testFormatShakespeareOutputFn() throws @UnknownKeyFor @NonNull @Initialized Exception {
        DoFnTester formatShakespeareOutputFn = DoFnTester.of((DoFn)new CombinePerKeyExamples.FormatShakespeareOutputFn());
        List results = formatShakespeareOutputFn.processBundle((Object[])COMBINED_TUPLES_ARRAY);
        MatcherAssert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem((Object)resultRow1));
        MatcherAssert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem((Object)resultRow2));
    }
}

