/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.Distinct;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DistinctExampleTest {
    @Rule
    public @UnknownKeyFor @NonNull @Initialized TestPipeline p = TestPipeline.create();

    @Test
    @Category(value={ValidatesRunner.class})
    public void testDistinct() {
        List<String> strings = Arrays.asList("k1", "k5", "k5", "k2", "k1", "k2", "k3");
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(strings).withCoder((Coder)StringUtf8Coder.of()));
        PCollection output = (PCollection)input.apply((PTransform)Distinct.create());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"k1", "k5", "k2", "k3"});
        this.p.run().waitUntilFinish();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testDistinctEmpty() {
        List<String> strings = Arrays.asList(new String[0]);
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(strings).withCoder((Coder)StringUtf8Coder.of()));
        PCollection output = (PCollection)input.apply((PTransform)Distinct.create());
        PAssert.that((PCollection)output).empty();
        this.p.run().waitUntilFinish();
    }
}

