/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableRow;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.examples.cookbook.JoinExamples;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JoinExamplesTest {
    private static final @UnknownKeyFor @NonNull @Initialized TableRow row1 = new TableRow().set("ActionGeo_CountryCode", (Object)"VM").set("SQLDATE", (Object)"20141212").set("Actor1Name", (Object)"BANGKOK").set("SOURCEURL", (Object)"http://cnn.com");
    private static final @UnknownKeyFor @NonNull @Initialized TableRow row2 = new TableRow().set("ActionGeo_CountryCode", (Object)"VM").set("SQLDATE", (Object)"20141212").set("Actor1Name", (Object)"LAOS").set("SOURCEURL", (Object)"http://www.chicagotribune.com");
    private static final @UnknownKeyFor @NonNull @Initialized TableRow row3 = new TableRow().set("ActionGeo_CountryCode", (Object)"BE").set("SQLDATE", (Object)"20141213").set("Actor1Name", (Object)"AFGHANISTAN").set("SOURCEURL", (Object)"http://cnn.com");
    static final @UnknownKeyFor @NonNull @Initialized TableRow @UnknownKeyFor @NonNull @Initialized [] EVENTS = new TableRow[]{row1, row2, row3};
    static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> EVENT_ARRAY = Arrays.asList(EVENTS);
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> PARSED_EVENTS = Arrays.asList(KV.of((Object)"VM", (Object)"Date: 20141212, Actor1: LAOS, url: http://www.chicagotribune.com"), KV.of((Object)"BE", (Object)"Date: 20141213, Actor1: AFGHANISTAN, url: http://cnn.com"), KV.of((Object)"VM", (Object)"Date: 20141212, Actor1: BANGKOK, url: http://cnn.com"));
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> PARSED_COUNTRY_CODES = Arrays.asList(KV.of((Object)"BE", (Object)"Belgium"), KV.of((Object)"VM", (Object)"Vietnam"));
    private static final @UnknownKeyFor @NonNull @Initialized TableRow cc1 = new TableRow().set("FIPSCC", (Object)"VM").set("HumanName", (Object)"Vietnam");
    private static final @UnknownKeyFor @NonNull @Initialized TableRow cc2 = new TableRow().set("FIPSCC", (Object)"BE").set("HumanName", (Object)"Belgium");
    static final @UnknownKeyFor @NonNull @Initialized TableRow @UnknownKeyFor @NonNull @Initialized [] CCS = new TableRow[]{cc1, cc2};
    static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> CC_ARRAY = Arrays.asList(CCS);
    static final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] JOINED_EVENTS = new String[]{"Country code: VM, Country name: Vietnam, Event info: Date: 20141212, Actor1: LAOS, url: http://www.chicagotribune.com", "Country code: VM, Country name: Vietnam, Event info: Date: 20141212, Actor1: BANGKOK, url: http://cnn.com", "Country code: BE, Country name: Belgium, Event info: Date: 20141213, Actor1: AFGHANISTAN, url: http://cnn.com"};
    @Rule
    public @UnknownKeyFor @NonNull @Initialized TestPipeline p = TestPipeline.create();

    @Test
    public void testExtractEventDataFn() throws @UnknownKeyFor @NonNull @Initialized Exception {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(EVENT_ARRAY))).apply((PTransform)ParDo.of((DoFn)new JoinExamples.ExtractEventDataFn()));
        PAssert.that((PCollection)output).containsInAnyOrder(PARSED_EVENTS);
        this.p.run().waitUntilFinish();
    }

    @Test
    public void testExtractCountryInfoFn() throws @UnknownKeyFor @NonNull @Initialized Exception {
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(CC_ARRAY))).apply((PTransform)ParDo.of((DoFn)new JoinExamples.ExtractCountryInfoFn()));
        PAssert.that((PCollection)output).containsInAnyOrder(PARSED_COUNTRY_CODES);
        this.p.run().waitUntilFinish();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testJoin() throws @UnknownKeyFor @NonNull @Initialized Exception {
        PCollection input1 = (PCollection)this.p.apply("CreateEvent", (PTransform)Create.of(EVENT_ARRAY));
        PCollection input2 = (PCollection)this.p.apply("CreateCC", (PTransform)Create.of(CC_ARRAY));
        PCollection output = JoinExamples.joinEvents((PCollection)input1, (PCollection)input2);
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])JOINED_EVENTS);
        this.p.run().waitUntilFinish();
    }
}

