/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableRow;
import java.util.List;
import org.apache.beam.examples.cookbook.MaxPerKeyExamples;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MaxPerKeyExamplesTest {
    private static final @UnknownKeyFor @NonNull @Initialized TableRow row1 = new TableRow().set("month", (Object)"6").set("day", (Object)"21").set("year", (Object)"2014").set("mean_temp", (Object)"85.3").set("tornado", (Object)true);
    private static final @UnknownKeyFor @NonNull @Initialized TableRow row2 = new TableRow().set("month", (Object)"7").set("day", (Object)"20").set("year", (Object)"2014").set("mean_temp", (Object)"75.4").set("tornado", (Object)false);
    private static final @UnknownKeyFor @NonNull @Initialized TableRow row3 = new TableRow().set("month", (Object)"6").set("day", (Object)"18").set("year", (Object)"2014").set("mean_temp", (Object)"45.3").set("tornado", (Object)true);
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> TEST_ROWS = ImmutableList.of((Object)row1, (Object)row2, (Object)row3);
    private static final @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Double> kv1 = KV.of((Object)6, (Object)85.3);
    private static final @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Double> kv2 = KV.of((Object)6, (Object)45.3);
    private static final @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Double> kv3 = KV.of((Object)7, (Object)75.4);
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Double>> TEST_KVS = ImmutableList.of(kv1, kv2, kv3);
    private static final @UnknownKeyFor @NonNull @Initialized TableRow resultRow1 = new TableRow().set("month", (Object)6).set("max_mean_temp", (Object)85.3);
    private static final @UnknownKeyFor @NonNull @Initialized TableRow resultRow2 = new TableRow().set("month", (Object)6).set("max_mean_temp", (Object)45.3);
    private static final @UnknownKeyFor @NonNull @Initialized TableRow resultRow3 = new TableRow().set("month", (Object)7).set("max_mean_temp", (Object)75.4);
    @Rule
    public @UnknownKeyFor @NonNull @Initialized TestPipeline p = TestPipeline.create();

    @Test
    @Category(value={ValidatesRunner.class})
    public void testExtractTempFn() {
        PCollection results = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(TEST_ROWS))).apply((PTransform)ParDo.of((DoFn)new MaxPerKeyExamples.ExtractTempFn()));
        PAssert.that((PCollection)results).containsInAnyOrder((Iterable)ImmutableList.of(kv1, kv2, kv3));
        this.p.run().waitUntilFinish();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFormatMaxesFn() {
        PCollection results = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(TEST_KVS))).apply((PTransform)ParDo.of((DoFn)new MaxPerKeyExamples.FormatMaxesFn()));
        PAssert.that((PCollection)results).containsInAnyOrder((Object[])new TableRow[]{resultRow1, resultRow2, resultRow3});
        this.p.run().waitUntilFinish();
    }
}

