/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.examples.cookbook.TriggerExample;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TriggerExampleTest {
    private static final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] INPUT = new String[]{"01/01/2010 00:00:00,1108302,94,E,ML,36,100,29,0.0065,66,9,1,0.001,74.8,1,9,3,0.0028,71,1,9,12,0.0099,67.4,1,9,13,0.0121,99.0,1,,,,,0,,,,,0,,,,,0,,,,,0", "01/01/2010 00:00:00,1100333,5,N,FR,9,0,39,,,9,,,,0,,,,,0,,,,,0,,,,,0,,,,,0,,,,,0,,,,,0,,,,", ""};
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TimestampedValue<@UnknownKeyFor @NonNull @Initialized String>> TIME_STAMPED_INPUT = Arrays.asList(TimestampedValue.of((Object)"01/01/2010 00:00:00,1108302,5,W,ML,36,100,30,0.0065,66,9,1,0.001,74.8,1,9,3,0.0028,71,1,9,12,0.0099,87.4,1,9,13,0.0121,99.0,1,,,,,0,,,,,0,,,,,0,,,,,0", (Instant)new Instant(60000L)), TimestampedValue.of((Object)"01/01/2010 00:00:00,1108302,110,E,ML,36,100,40,0.0065,66,9,1,0.001,74.8,1,9,3,0.0028,71,1,9,12,0.0099,67.4,1,9,13,0.0121,99.0,1,,,,,0,,,,,0,,,,,0,,,,,0", (Instant)new Instant(1L)), TimestampedValue.of((Object)"01/01/2010 00:00:00,1108302,110,E,ML,36,100,50,0.0065,66,9,1,0.001,74.8,1,9,3,0.0028,71,1,9,12,0.0099,97.4,1,9,13,0.0121,50.0,1,,,,,0,,,,,0,,,,,0,,,,,0", (Instant)new Instant(1L)));
    private static final @UnknownKeyFor @NonNull @Initialized TableRow OUT_ROW_1 = new TableRow().set("trigger_type", (Object)"default").set("freeway", (Object)"5").set("total_flow", (Object)30).set("number_of_records", (Object)1).set("isFirst", (Object)true).set("isLast", (Object)true).set("timing", (Object)"ON_TIME").set("window", (Object)"[1970-01-01T00:01:00.000Z..1970-01-01T00:02:00.000Z)");
    private static final @UnknownKeyFor @NonNull @Initialized TableRow OUT_ROW_2 = new TableRow().set("trigger_type", (Object)"default").set("freeway", (Object)"110").set("total_flow", (Object)90).set("number_of_records", (Object)2).set("isFirst", (Object)true).set("isLast", (Object)true).set("timing", (Object)"ON_TIME").set("window", (Object)"[1970-01-01T00:00:00.000Z..1970-01-01T00:01:00.000Z)");
    @Rule
    public @UnknownKeyFor @NonNull @Initialized TestPipeline pipeline = TestPipeline.create();

    @Test
    public void testExtractTotalFlow() {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(Arrays.asList(INPUT)).withCoder((Coder)StringUtf8Coder.of()))).apply((PTransform)ParDo.of((DoFn)new TriggerExample.ExtractFlowInfo()));
        KV expectedOutput = KV.of((Object)"94", (Object)29);
        PAssert.that((PCollection)output).containsInAnyOrder(Arrays.asList(expectedOutput));
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testTotalFlow() {
        PCollection flow = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.timestamped(TIME_STAMPED_INPUT))).apply((PTransform)ParDo.of((DoFn)new TriggerExample.ExtractFlowInfo()));
        PCollection totalFlow = (PCollection)((PCollection)flow.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)1L))))).apply((PTransform)new TriggerExample.TotalFlow("default"));
        PCollection results = (PCollection)totalFlow.apply((PTransform)ParDo.of((DoFn)new FormatResults()));
        PAssert.that((PCollection)results).containsInAnyOrder((Object[])new String[]{TriggerExampleTest.canonicalFormat(OUT_ROW_1), TriggerExampleTest.canonicalFormat(OUT_ROW_2)});
        this.pipeline.run().waitUntilFinish();
    }

    static @UnknownKeyFor @NonNull @Initialized String canonicalFormat(@UnknownKeyFor @NonNull @Initialized TableRow row) {
        ArrayList entries = Lists.newArrayListWithCapacity((int)row.size());
        for (Map.Entry entry : row.entrySet()) {
            entries.add((String)entry.getKey() + ":" + entry.getValue());
        }
        Collections.sort(entries);
        return Joiner.on((String)",").join((Iterable)entries);
    }

    static class FormatResults
    extends DoFn<TableRow, String> {
        FormatResults() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            TableRow element = (TableRow)c.element();
            TableRow row = new TableRow().set("trigger_type", element.get((Object)"trigger_type")).set("freeway", element.get((Object)"freeway")).set("total_flow", element.get((Object)"total_flow")).set("number_of_records", element.get((Object)"number_of_records")).set("isFirst", element.get((Object)"isFirst")).set("isLast", element.get((Object)"isLast")).set("timing", element.get((Object)"timing")).set("window", element.get((Object)"window"));
            c.output((Object)TriggerExampleTest.canonicalFormat(row));
        }
    }
}

