/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.beam.examples.DebuggingWordCount;
import org.apache.beam.examples.java.repackaged.com.google.common.io.Files;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.TestPipeline;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DebuggingWordCountTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    private String getFilePath(String filePath) {
        if (filePath.contains(":")) {
            return filePath.replace("\\", "/").split(":")[1];
        }
        return filePath;
    }

    @Test
    public void testDebuggingWordCount() throws Exception {
        File inputFile = this.tmpFolder.newFile();
        File outputFile = this.tmpFolder.newFile();
        Files.write((CharSequence)"stomach secret Flourish message Flourish here Flourish", (File)inputFile, (Charset)StandardCharsets.UTF_8);
        DebuggingWordCount.WordCountOptions options = (DebuggingWordCount.WordCountOptions)TestPipeline.testingPipelineOptions().as(DebuggingWordCount.WordCountOptions.class);
        options.setInputFile(this.getFilePath(inputFile.getAbsolutePath()));
        options.setOutput(this.getFilePath(outputFile.getAbsolutePath()));
        DebuggingWordCount.main((String[])TestPipeline.convertToArgs((PipelineOptions)options));
    }
}

