/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.examples.Snippets;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SnippetsTest
implements Serializable {
    @Rule
    public transient TestPipeline p = TestPipeline.create();

    @Test
    public void testCoGroupByKeyTuple() throws IOException {
        List<KV> emailsList = Arrays.asList(KV.of((Object)"amy", (Object)"amy@example.com"), KV.of((Object)"carl", (Object)"carl@example.com"), KV.of((Object)"julia", (Object)"julia@example.com"), KV.of((Object)"carl", (Object)"carl@email.com"));
        List<KV> phonesList = Arrays.asList(KV.of((Object)"amy", (Object)"111-222-3333"), KV.of((Object)"james", (Object)"222-333-4444"), KV.of((Object)"amy", (Object)"333-444-5555"), KV.of((Object)"carl", (Object)"444-555-6666"));
        PCollection emails = (PCollection)this.p.apply("CreateEmails", (PTransform)Create.of(emailsList));
        PCollection phones = (PCollection)this.p.apply("CreatePhones", (PTransform)Create.of(phonesList));
        TupleTag emailsTag = new TupleTag();
        TupleTag phonesTag = new TupleTag();
        List<KV> expectedResults = Arrays.asList(KV.of((Object)"amy", (Object)CoGbkResult.of((TupleTag)emailsTag, Arrays.asList("amy@example.com")).and(phonesTag, Arrays.asList("111-222-3333", "333-444-5555"))), KV.of((Object)"carl", (Object)CoGbkResult.of((TupleTag)emailsTag, Arrays.asList("carl@email.com", "carl@example.com")).and(phonesTag, Arrays.asList("444-555-6666"))), KV.of((Object)"james", (Object)CoGbkResult.of((TupleTag)emailsTag, Arrays.asList(new String[0])).and(phonesTag, Arrays.asList("222-333-4444"))), KV.of((Object)"julia", (Object)CoGbkResult.of((TupleTag)emailsTag, Arrays.asList("julia@example.com")).and(phonesTag, Arrays.asList(new String[0]))));
        PCollection actualFormattedResults = Snippets.coGroupByKeyTuple((TupleTag)emailsTag, (TupleTag)phonesTag, (PCollection)emails, (PCollection)phones);
        List<String> formattedResults = Arrays.asList("amy; ['amy@example.com']; ['111-222-3333', '333-444-5555']", "carl; ['carl@email.com', 'carl@example.com']; ['444-555-6666']", "james; []; ['222-333-4444']", "julia; ['julia@example.com']; []");
        ArrayList<String> expectedFormattedResultsList = new ArrayList<String>(expectedResults.size());
        for (KV e : expectedResults) {
            String name = (String)e.getKey();
            Iterable emailsIter = ((CoGbkResult)e.getValue()).getAll(emailsTag);
            Iterable phonesIter = ((CoGbkResult)e.getValue()).getAll(phonesTag);
            String formattedResult = Snippets.formatCoGbkResults((String)name, (Iterable)emailsIter, (Iterable)phonesIter);
            expectedFormattedResultsList.add(formattedResult);
        }
        PCollection expectedFormattedResultsPColl = (PCollection)this.p.apply((PTransform)Create.of(expectedFormattedResultsList));
        PAssert.that((PCollection)expectedFormattedResultsPColl).containsInAnyOrder(formattedResults);
        PAssert.that((PCollection)actualFormattedResults).containsInAnyOrder(formattedResults);
        this.p.run();
    }
}

