/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableRow;
import java.util.List;
import org.apache.beam.examples.cookbook.BigQueryTornadoes;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.apache.beam.sdk.values.KV;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryTornadoesTest {
    @Test
    public void testExtractTornadoes() throws Exception {
        TableRow row = new TableRow().set("month", (Object)"6").set("tornado", (Object)true);
        DoFnTester extractWordsFn = DoFnTester.of((DoFn)new BigQueryTornadoes.ExtractTornadoesFn());
        Assert.assertThat((Object)extractWordsFn.processBundle((Object[])new TableRow[]{row}), (Matcher)CoreMatchers.hasItems((Object[])new Integer[]{6}));
    }

    @Test
    public void testNoTornadoes() throws Exception {
        TableRow row = new TableRow().set("month", (Object)6).set("tornado", (Object)false);
        DoFnTester extractWordsFn = DoFnTester.of((DoFn)new BigQueryTornadoes.ExtractTornadoesFn());
        Assert.assertTrue((boolean)extractWordsFn.processBundle((Object[])new TableRow[]{row}).isEmpty());
    }

    @Test
    public void testFormatCounts() throws Exception {
        Object[] empty;
        DoFnTester formatCountsFn = DoFnTester.of((DoFn)new BigQueryTornadoes.FormatCountsFn());
        List results = formatCountsFn.processBundle(empty = new KV[0]);
        Assert.assertTrue((results.size() == 0 ? 1 : 0) != 0);
        Object[] input = new KV[]{KV.of((Object)3, (Object)0L), KV.of((Object)4, (Object)Long.MAX_VALUE), KV.of((Object)5, (Object)Long.MIN_VALUE)};
        results = formatCountsFn.processBundle(input);
        Assert.assertEquals((long)results.size(), (long)3L);
        Assert.assertEquals((Object)((TableRow)results.get(0)).get((Object)"month"), (Object)3);
        Assert.assertEquals((Object)((TableRow)results.get(0)).get((Object)"tornado_count"), (Object)0L);
        Assert.assertEquals((Object)((TableRow)results.get(1)).get((Object)"month"), (Object)4);
        Assert.assertEquals((Object)((TableRow)results.get(1)).get((Object)"tornado_count"), (Object)Long.MAX_VALUE);
        Assert.assertEquals((Object)((TableRow)results.get(2)).get((Object)"month"), (Object)5);
        Assert.assertEquals((Object)((TableRow)results.get(2)).get((Object)"tornado_count"), (Object)Long.MIN_VALUE);
    }
}

