/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableRow;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.examples.cookbook.FilterExamples;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FilterExamplesTest {
    private static final TableRow row1 = new TableRow().set("month", (Object)"6").set("day", (Object)"21").set("year", (Object)"2014").set("mean_temp", (Object)"85.3").set("tornado", (Object)true);
    private static final TableRow row2 = new TableRow().set("month", (Object)"7").set("day", (Object)"20").set("year", (Object)"2014").set("mean_temp", (Object)"75.4").set("tornado", (Object)false);
    private static final TableRow row3 = new TableRow().set("month", (Object)"6").set("day", (Object)"18").set("year", (Object)"2014").set("mean_temp", (Object)"45.3").set("tornado", (Object)true);
    static final TableRow[] ROWS_ARRAY = new TableRow[]{row1, row2, row3};
    static final List<TableRow> ROWS = Arrays.asList(ROWS_ARRAY);
    private static final TableRow outRow1 = new TableRow().set("year", (Object)2014).set("month", (Object)6).set("day", (Object)21).set("mean_temp", (Object)85.3);
    private static final TableRow outRow2 = new TableRow().set("year", (Object)2014).set("month", (Object)7).set("day", (Object)20).set("mean_temp", (Object)75.4);
    private static final TableRow outRow3 = new TableRow().set("year", (Object)2014).set("month", (Object)6).set("day", (Object)18).set("mean_temp", (Object)45.3);
    private static final TableRow[] PROJROWS_ARRAY = new TableRow[]{outRow1, outRow2, outRow3};

    @Test
    public void testProjectionFn() throws Exception {
        DoFnTester projectionFn = DoFnTester.of((DoFn)new FilterExamples.ProjectionFn());
        List results = projectionFn.processBundle((Object[])ROWS_ARRAY);
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem((Object)outRow1));
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem((Object)outRow2));
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem((Object)outRow3));
    }

    @Test
    public void testFilterSingleMonthDataFn() throws Exception {
        DoFnTester filterSingleMonthDataFn = DoFnTester.of((DoFn)new FilterExamples.FilterSingleMonthDataFn(Integer.valueOf(7)));
        List results = filterSingleMonthDataFn.processBundle((Object[])PROJROWS_ARRAY);
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem((Object)outRow2));
    }
}

