/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableRow;
import java.util.List;
import org.apache.beam.examples.cookbook.MaxPerKeyExamples;
import org.apache.beam.examples.java.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.apache.beam.sdk.values.KV;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MaxPerKeyExamplesTest {
    private static final TableRow row1 = new TableRow().set("month", (Object)"6").set("day", (Object)"21").set("year", (Object)"2014").set("mean_temp", (Object)"85.3").set("tornado", (Object)true);
    private static final TableRow row2 = new TableRow().set("month", (Object)"7").set("day", (Object)"20").set("year", (Object)"2014").set("mean_temp", (Object)"75.4").set("tornado", (Object)false);
    private static final TableRow row3 = new TableRow().set("month", (Object)"6").set("day", (Object)"18").set("year", (Object)"2014").set("mean_temp", (Object)"45.3").set("tornado", (Object)true);
    private static final List<TableRow> TEST_ROWS = ImmutableList.of((Object)row1, (Object)row2, (Object)row3);
    private static final KV<Integer, Double> kv1 = KV.of((Object)6, (Object)85.3);
    private static final KV<Integer, Double> kv2 = KV.of((Object)6, (Object)45.3);
    private static final KV<Integer, Double> kv3 = KV.of((Object)7, (Object)75.4);
    private static final List<KV<Integer, Double>> TEST_KVS = ImmutableList.of(kv1, kv2, kv3);
    private static final TableRow resultRow1 = new TableRow().set("month", (Object)6).set("max_mean_temp", (Object)85.3);
    private static final TableRow resultRow2 = new TableRow().set("month", (Object)7).set("max_mean_temp", (Object)75.4);

    @Test
    public void testExtractTempFn() throws Exception {
        DoFnTester extractTempFn = DoFnTester.of((DoFn)new MaxPerKeyExamples.ExtractTempFn());
        List results = extractTempFn.processBundle(TEST_ROWS);
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem(kv1));
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem(kv2));
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem(kv3));
    }

    @Test
    public void testFormatMaxesFn() throws Exception {
        DoFnTester formatMaxesFnFn = DoFnTester.of((DoFn)new MaxPerKeyExamples.FormatMaxesFn());
        List results = formatMaxesFnFn.processBundle(TEST_KVS);
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem((Object)resultRow1));
        Assert.assertThat((Object)results, (Matcher)CoreMatchers.hasItem((Object)resultRow2));
    }
}

