/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;

public class Snippets {
    public static String formatCoGbkResults(String name, Iterable<String> emails, Iterable<String> phones) {
        ArrayList<String> emailsList = new ArrayList<String>();
        for (String elem : emails) {
            emailsList.add("'" + elem + "'");
        }
        Collections.sort(emailsList);
        String emailsStr = "[" + String.join((CharSequence)", ", emailsList) + "]";
        ArrayList<String> phonesList = new ArrayList<String>();
        for (String elem : phones) {
            phonesList.add("'" + elem + "'");
        }
        Collections.sort(phonesList);
        String phonesStr = "[" + String.join((CharSequence)", ", phonesList) + "]";
        return name + "; " + emailsStr + "; " + phonesStr;
    }

    public static PCollection<String> coGroupByKeyTuple(final TupleTag<String> emailsTag, final TupleTag<String> phonesTag, PCollection<KV<String, String>> emails, PCollection<KV<String, String>> phones) {
        PCollection results = (PCollection)KeyedPCollectionTuple.of(emailsTag, emails).and(phonesTag, phones).apply((PTransform)CoGroupByKey.create());
        PCollection contactLines = (PCollection)results.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<String, CoGbkResult>, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                KV e = (KV)c.element();
                String name = (String)e.getKey();
                Iterable emailsIter = ((CoGbkResult)e.getValue()).getAll(emailsTag);
                Iterable phonesIter = ((CoGbkResult)e.getValue()).getAll(phonesTag);
                String formattedResult = Snippets.formatCoGbkResults(name, emailsIter, phonesIter);
                c.output((Object)formattedResult);
            }
        }));
        return contactLines;
    }
}

