/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.examples.common.ExampleBigQueryTableOptions;
import org.apache.beam.examples.common.ExampleOptions;
import org.apache.beam.examples.common.ExampleUtils;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;

public class StreamingWordExtract {
    public static void main(String[] args) throws IOException {
        StreamingWordExtractOptions options = (StreamingWordExtractOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(StreamingWordExtractOptions.class);
        options.setStreaming(true);
        options.setBigQuerySchema(StringToRowConverter.getSchema());
        ExampleUtils exampleUtils = new ExampleUtils(options);
        exampleUtils.setup();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        String tableSpec = options.getProject() + ":" + options.getBigQueryDataset() + "." + options.getBigQueryTable();
        ((PCollection)((PCollection)((PCollection)((PCollection)pipeline.apply("ReadLines", (PTransform)TextIO.read().from(options.getInputFile()))).apply((PTransform)ParDo.of((DoFn)new ExtractWords()))).apply((PTransform)ParDo.of((DoFn)new Uppercase()))).apply((PTransform)ParDo.of((DoFn)new StringToRowConverter()))).apply((PTransform)BigQueryIO.writeTableRows().to(tableSpec).withSchema(StringToRowConverter.getSchema()));
        PipelineResult result = pipeline.run();
        exampleUtils.waitToFinish(result);
    }

    private static interface StreamingWordExtractOptions
    extends ExampleOptions,
    ExampleBigQueryTableOptions,
    StreamingOptions {
        @Description(value="Path of the file to read from")
        @Default.String(value="gs://apache-beam-samples/shakespeare/kinglear.txt")
        public String getInputFile();

        public void setInputFile(String var1);
    }

    static class StringToRowConverter
    extends DoFn<String, TableRow> {
        StringToRowConverter() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)new TableRow().set("string_field", c.element()));
        }

        static TableSchema getSchema() {
            return new TableSchema().setFields((List)new ArrayList<TableFieldSchema>(){
                {
                    this.add(new TableFieldSchema().setName("string_field").setType("STRING"));
                }
            });
        }
    }

    static class Uppercase
    extends DoFn<String, String> {
        Uppercase() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)((String)c.element()).toUpperCase());
        }
    }

    static class ExtractWords
    extends DoFn<String, String> {
        ExtractWords() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            String[] words;
            for (String word : words = ((String)c.element()).split("[^\\p{L}]+")) {
                if (word.isEmpty()) continue;
                c.output((Object)word);
            }
        }
    }
}

