/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

public class BigQueryTornadoes {
    private static final String WEATHER_SAMPLES_TABLE = "clouddataflow-readonly:samples.weather_stations";

    public static void main(String[] args) {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>();
        fields.add(new TableFieldSchema().setName("month").setType("INTEGER"));
        fields.add(new TableFieldSchema().setName("tornado_count").setType("INTEGER"));
        TableSchema schema = new TableSchema().setFields(fields);
        ((PCollection)((PCollection)p.apply((PTransform)BigQueryIO.readTableRows().from(options.getInput()))).apply((PTransform)new CountTornadoes())).apply((PTransform)BigQueryIO.writeTableRows().to(options.getOutput()).withSchema(schema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        p.run().waitUntilFinish();
    }

    public static interface Options
    extends PipelineOptions {
        @Description(value="Table to read from, specified as <project_id>:<dataset_id>.<table_id>")
        @Default.String(value="clouddataflow-readonly:samples.weather_stations")
        public String getInput();

        public void setInput(String var1);

        @Description(value="BigQuery table to write to, specified as <project_id>:<dataset_id>.<table_id>. The dataset must already exist.")
        @Validation.Required
        public String getOutput();

        public void setOutput(String var1);
    }

    static class CountTornadoes
    extends PTransform<PCollection<TableRow>, PCollection<TableRow>> {
        CountTornadoes() {
        }

        public PCollection<TableRow> expand(PCollection<TableRow> rows) {
            PCollection tornadoes = (PCollection)rows.apply((PTransform)ParDo.of((DoFn)new ExtractTornadoesFn()));
            PCollection tornadoCounts = (PCollection)tornadoes.apply(Count.perElement());
            PCollection results = (PCollection)tornadoCounts.apply((PTransform)ParDo.of((DoFn)new FormatCountsFn()));
            return results;
        }
    }

    static class FormatCountsFn
    extends DoFn<KV<Integer, Long>, TableRow> {
        FormatCountsFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            TableRow row = new TableRow().set("month", ((KV)c.element()).getKey()).set("tornado_count", ((KV)c.element()).getValue());
            c.output((Object)row);
        }
    }

    static class ExtractTornadoesFn
    extends DoFn<TableRow, Integer> {
        ExtractTornadoesFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            TableRow row = (TableRow)c.element();
            if (((Boolean)row.get((Object)"tornado")).booleanValue()) {
                c.output((Object)Integer.parseInt((String)row.get((Object)"month")));
            }
        }
    }
}

