/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete;

import java.util.Date;
import java.util.regex.Pattern;
import org.apache.beam.examples.complete.TfIdf;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.FileChecksumMatcher;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.util.NumberedShardedFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TfIdfIT {
    private static final String DEFAULT_INPUT = "gs://apache-beam-samples/shakespeare/";
    private static final String EXPECTED_OUTPUT_CHECKSUM = "0549d1dc8821976121771aefcb0e2297177bdb88";
    private static final Pattern DEFAULT_SHARD_TEMPLATE = Pattern.compile("(?x) \\S* (?<shardnum> \\d+) -of- (?<numshards> \\d+)\\.csv");

    @BeforeClass
    public static void setUp() {
        PipelineOptionsFactory.register(TfIdfITOptions.class);
    }

    @Test
    public void testE2ETfIdf() throws Exception {
        TfIdfITOptions options = (TfIdfITOptions)TestPipeline.testingPipelineOptions().as(TfIdfITOptions.class);
        options.setInput(DEFAULT_INPUT);
        options.setOutput(FileSystems.matchNewResource((String)options.getTempRoot(), (boolean)true).resolve(String.format("TfIdfIT-%tF-%<tH-%<tM-%<tS-%<tL", new Date()), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("output", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("results", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString());
        TfIdf.runTfIdf((TfIdf.Options)options);
        MatcherAssert.assertThat((Object)new NumberedShardedFile(options.getOutput() + "*-of-*.csv", DEFAULT_SHARD_TEMPLATE), (Matcher)FileChecksumMatcher.fileContentsHaveChecksum((String)EXPECTED_OUTPUT_CHECKSUM));
    }

    public static interface TfIdfITOptions
    extends TestPipelineOptions,
    TfIdf.Options {
    }
}

