/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.examples.cookbook.FilterExamples;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FilterExamplesTest {
    private static final TableRow row1 = new TableRow().set("month", (Object)"6").set("day", (Object)"21").set("year", (Object)"2014").set("mean_temp", (Object)"85.3").set("tornado", (Object)true);
    private static final TableRow row2 = new TableRow().set("month", (Object)"7").set("day", (Object)"20").set("year", (Object)"2014").set("mean_temp", (Object)"75.4").set("tornado", (Object)false);
    private static final TableRow row3 = new TableRow().set("month", (Object)"6").set("day", (Object)"18").set("year", (Object)"2014").set("mean_temp", (Object)"45.3").set("tornado", (Object)true);
    private static final TableRow outRow1 = new TableRow().set("year", (Object)2014).set("month", (Object)6).set("day", (Object)21).set("mean_temp", (Object)85.3);
    private static final TableRow outRow2 = new TableRow().set("year", (Object)2014).set("month", (Object)7).set("day", (Object)20).set("mean_temp", (Object)75.4);
    private static final TableRow outRow3 = new TableRow().set("year", (Object)2014).set("month", (Object)6).set("day", (Object)18).set("mean_temp", (Object)45.3);
    @Rule
    public TestPipeline p = TestPipeline.create();

    @Test
    @Category(value={ValidatesRunner.class})
    public void testProjectionFn() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of((Object)row1, (Object[])new TableRow[]{row2, row3}));
        PCollection results = (PCollection)input.apply((PTransform)ParDo.of((DoFn)new FilterExamples.ProjectionFn()));
        PAssert.that((PCollection)results).containsInAnyOrder((Object[])new TableRow[]{outRow1, outRow2, outRow3});
        this.p.run().waitUntilFinish();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFilterSingleMonthDataFn() {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of((Object)outRow1, (Object[])new TableRow[]{outRow2, outRow3}));
        PCollection results = (PCollection)input.apply((PTransform)ParDo.of((DoFn)new FilterExamples.FilterSingleMonthDataFn(Integer.valueOf(7))));
        PAssert.that((PCollection)results).containsInAnyOrder((Object[])new TableRow[]{outRow2});
        this.p.run().waitUntilFinish();
    }
}

