/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.transforms;

import java.io.Serializable;
import org.apache.beam.examples.complete.datatokenization.DataTokenization;
import org.apache.beam.examples.complete.datatokenization.transforms.SerializableFunctions;
import org.apache.beam.examples.complete.datatokenization.utils.ErrorConverters;
import org.apache.beam.examples.complete.datatokenization.utils.FailsafeElement;
import org.apache.beam.examples.complete.datatokenization.utils.SchemasUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.JsonToRow;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;

public class JsonToBeamRow
extends PTransform<PCollection<String>, PCollection<Row>> {
    private final String failedToParseDeadLetterPath;
    private final transient SchemasUtils schema;

    public JsonToBeamRow(String failedToParseDeadLetterPath, SchemasUtils schema) {
        this.failedToParseDeadLetterPath = failedToParseDeadLetterPath;
        this.schema = schema;
    }

    public PCollection<Row> expand(PCollection<String> jsons) {
        JsonToRow.ParseResult rows = (JsonToRow.ParseResult)jsons.apply("JsonToRow", (PTransform)JsonToRow.withExceptionReporting((Schema)this.schema.getBeamSchema()).withExtendedErrorInfo());
        if (this.failedToParseDeadLetterPath != null) {
            ((PCollection)rows.getFailedToParseLines().apply("ToFailsafeElement", (PTransform)MapElements.into(DataTokenization.FAILSAFE_ELEMENT_CODER.getEncodedTypeDescriptor()).via((SerializableFunction & Serializable)errRow -> FailsafeElement.of(Strings.nullToEmpty((String)errRow.getString("line")), Strings.nullToEmpty((String)errRow.getString("line"))).setErrorMessage(Strings.nullToEmpty((String)errRow.getString("err")))))).apply("WriteCsvConversionErrorsToFS", ErrorConverters.WriteErrorsToTextIO.newBuilder().setErrorWritePath(this.failedToParseDeadLetterPath).setTranslateFunction(SerializableFunctions.getCsvErrorConverter()).build());
        }
        return rows.getResults().setRowSchema(this.schema.getBeamSchema());
    }
}

