/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.kafkatopubsub.options;

import org.apache.beam.examples.complete.kafkatopubsub.transforms.FormatTransform;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.Validation;

public interface KafkaToPubsubOptions
extends PipelineOptions {
    @Description(value="Comma Separated list of Kafka Bootstrap Servers (e.g: server1:[port],server2:[port]).")
    @Validation.Required
    public String getBootstrapServers();

    public void setBootstrapServers(String var1);

    @Description(value="Comma Separated list of Kafka topic(s) to read the input from (e.g: topic1,topic2).")
    @Validation.Required
    public String getInputTopics();

    public void setInputTopics(String var1);

    @Description(value="The Cloud Pub/Sub topic to publish to. The name should be in the format of projects/<project-id>/topics/<topic-name>.")
    @Validation.Required
    public String getOutputTopic();

    public void setOutputTopic(String var1);

    @Description(value="Format which will be writen to output Pub/Sub topic. Supported formats: AVRO, PUBSUB")
    @Validation.Required
    public FormatTransform.FORMAT getOutputFormat();

    public void setOutputFormat(FormatTransform.FORMAT var1);

    @Description(value="URL to credentials in Vault")
    public String getSecretStoreUrl();

    public void setSecretStoreUrl(String var1);

    @Description(value="Vault token")
    public String getVaultToken();

    public void setVaultToken(String var1);

    @Description(value="The path to the trust store file")
    public String getTruststorePath();

    public void setTruststorePath(String var1);

    @Description(value="The path to the key store file")
    public String getKeystorePath();

    public void setKeystorePath(String var1);

    @Description(value="The password for the trust store password")
    public String getTruststorePassword();

    public void setTruststorePassword(String var1);

    @Description(value="The store password for the key store password")
    public String getKeystorePassword();

    public void setKeystorePassword(String var1);

    @Description(value="The password of the private key in the key store file")
    public String getKeyPassword();

    public void setKeyPassword(String var1);

    @Description(value="Additional kafka consumer configs to be applied to Kafka Consumer (e.g. key1=value1;key2=value2).")
    public String getKafkaConsumerConfig();

    public void setKafkaConsumerConfig(String var1);
}

