/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.snippets;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import com.google.cloud.language.v1.AnnotateTextRequest;
import com.google.cloud.language.v1.AnnotateTextResponse;
import com.google.cloud.language.v1.Document;
import com.google.cloud.language.v1.Entity;
import com.google.cloud.language.v1.Sentence;
import com.google.cloud.language.v1.Token;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.extensions.ml.AnnotateText;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.Join;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.PeriodicImpulse;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.Watch;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.TimestampObservingWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Snippets {
    private static final Logger LOG = LoggerFactory.getLogger(Snippets.class);
    private static final Duration gapDuration = Duration.standardSeconds((long)10L);

    public static void modelBigQueryIO(Pipeline p) {
        Snippets.modelBigQueryIO(p, "", "", "");
    }

    public static void modelBigQueryIO(Pipeline p, final String writeProject, final String writeDataset, final String writeTable) {
        String string = "clouddataflow-readonly:samples.weather_stations";
        string = "samples.weather_stations";
        string = new TableReference().setProjectId("clouddataflow-readonly").setDatasetId("samples").setTableId("weather_stations");
        TableRow row2 = new TableRow();
        row2.set("string", (Object)"abc");
        Object rawbytes = new byte[]{-85, -84};
        row2.set("bytes", (Object)Base64.getEncoder().encodeToString((byte[])rawbytes));
        row2.set("integer", (Object)5);
        row2.set("float", (Object)0.5);
        row2.set("numeric", (Object)5);
        row2.set("boolean", (Object)true);
        row2.set("timestamp", (Object)"2018-12-31 12:44:31.744957 UTC");
        row2.set("date", (Object)"2018-12-31");
        row2.set("time", (Object)"12:44:31");
        row2.set("datetime", (Object)"2019-06-11T14:44:31");
        row2.set("geography", (Object)"POINT(30 10)");
        String tableSpec = "clouddataflow-readonly:samples.weather_stations";
        rawbytes = (PCollection)((PCollection)p.apply((PTransform)BigQueryIO.readTableRows().from(tableSpec))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.doubles()).via((SerializableFunction & Serializable)row -> (Double)row.get((Object)"max_temperature")));
        tableSpec = "clouddataflow-readonly:samples.weather_stations";
        rawbytes = (PCollection)p.apply((PTransform)BigQueryIO.read((SerializableFunction & Serializable)elem -> (Double)elem.getRecord().get("max_temperature")).from(tableSpec).withCoder((Coder)DoubleCoder.of()));
        tableSpec = (PCollection)p.apply((PTransform)BigQueryIO.read((SerializableFunction & Serializable)elem -> (Double)elem.getRecord().get("max_temperature")).fromQuery("SELECT max_temperature FROM [clouddataflow-readonly:samples.weather_stations]").withCoder((Coder)DoubleCoder.of()));
        tableSpec = (PCollection)p.apply((PTransform)BigQueryIO.read((SerializableFunction & Serializable)elem -> (Double)elem.getRecord().get("max_temperature")).fromQuery("SELECT max_temperature FROM `clouddataflow-readonly.samples.weather_stations`").usingStandardSql().withCoder((Coder)DoubleCoder.of()));
        String tableSchemaJson = "{  \"fields\": [    {      \"name\": \"source\",      \"type\": \"STRING\",      \"mode\": \"NULLABLE\"    },    {      \"name\": \"quote\",      \"type\": \"STRING\",      \"mode\": \"REQUIRED\"    }  ]}";
        String tableSpec2 = "clouddataflow-readonly:samples.weather_stations";
        if (!(writeProject.isEmpty() || writeDataset.isEmpty() || writeTable.isEmpty())) {
            tableSpec2 = writeProject + ":" + writeDataset + "." + writeTable;
        }
        TableSchema tableSchema = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("source").setType("STRING").setMode("NULLABLE"), (Object)new TableFieldSchema().setName("quote").setType("STRING").setMode("REQUIRED")));
        PCollection quotes = (PCollection)p.apply((PTransform)Create.of((Object)new Quote("Mahatma Gandhi", "My life is my message."), (Object[])new Quote[]{new Quote("Yoda", "Do, or do not. There is no 'try'.")}));
        ((PCollection)quotes.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(TableRow.class)).via((SerializableFunction & Serializable)elem -> new TableRow().set("source", (Object)elem.source).set("quote", (Object)elem.quote)))).apply((PTransform)BigQueryIO.writeTableRows().to(tableSpec2).withSchema(tableSchema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        quotes.apply((PTransform)BigQueryIO.write().to(tableSpec2).withSchema(tableSchema).withFormatFunction((SerializableFunction & Serializable)elem -> new TableRow().set("source", (Object)elem.source).set("quote", (Object)elem.quote)).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        quotes.apply((PTransform)BigQueryIO.write().to(tableSpec2).withJsonSchema(tableSchemaJson).withFormatFunction((SerializableFunction & Serializable)elem -> new TableRow().set("source", (Object)elem.source).set("quote", (Object)elem.quote)).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        PCollection weatherData = (PCollection)p.apply((PTransform)BigQueryIO.read((SerializableFunction & Serializable)elem -> {
            GenericRecord record = elem.getRecord();
            return new WeatherData((Long)record.get("year"), (Long)record.get("month"), (Long)record.get("day"), (Double)record.get("max_temperature"));
        }).fromQuery("SELECT year, month, day, max_temperature FROM [clouddataflow-readonly:samples.weather_stations] WHERE year BETWEEN 2007 AND 2009").withCoder((Coder)AvroCoder.of(WeatherData.class)));
        weatherData.apply((PTransform)BigQueryIO.write().to((DynamicDestinations)new DynamicDestinations<WeatherData, Long>(){

            public Long getDestination(ValueInSingleWindow<WeatherData> elem) {
                return ((WeatherData)elem.getValue()).year;
            }

            public TableDestination getTable(Long destination) {
                return new TableDestination(new TableReference().setProjectId(writeProject).setDatasetId(writeDataset).setTableId(writeTable + "_" + destination), "Table for year " + destination);
            }

            public TableSchema getSchema(Long destination) {
                return new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("year").setType("INTEGER").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("month").setType("INTEGER").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("day").setType("INTEGER").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("maxTemp").setType("FLOAT").setMode("NULLABLE")));
            }
        }).withFormatFunction((SerializableFunction & Serializable)elem -> new TableRow().set("year", (Object)elem.year).set("month", (Object)elem.month).set("day", (Object)elem.day).set("maxTemp", (Object)elem.maxTemp)).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        String tableSpec3 = "clouddataflow-readonly:samples.weather_stations";
        if (!(writeProject.isEmpty() || writeDataset.isEmpty() || writeTable.isEmpty())) {
            tableSpec3 = writeProject + ":" + writeDataset + "." + writeTable + "_partitioning";
        }
        TableSchema tableSchema2 = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("year").setType("INTEGER").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("month").setType("INTEGER").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("day").setType("INTEGER").setMode("REQUIRED"), (Object)new TableFieldSchema().setName("maxTemp").setType("FLOAT").setMode("NULLABLE")));
        weatherData.apply((PTransform)BigQueryIO.write().to(tableSpec3 + "_partitioning").withSchema(tableSchema2).withFormatFunction((SerializableFunction & Serializable)elem -> new TableRow().set("year", (Object)elem.year).set("month", (Object)elem.month).set("day", (Object)elem.day).set("maxTemp", (Object)elem.maxTemp)).withTimePartitioning(new TimePartitioning().setType("DAY")).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
    }

    public static String formatCoGbkResults(String name, Iterable<String> emails, Iterable<String> phones) {
        ArrayList<String> emailsList = new ArrayList<String>();
        for (String elem : emails) {
            emailsList.add("'" + elem + "'");
        }
        Collections.sort(emailsList);
        String emailsStr = "[" + String.join((CharSequence)", ", emailsList) + "]";
        ArrayList<String> phonesList = new ArrayList<String>();
        for (String elem : phones) {
            phonesList.add("'" + elem + "'");
        }
        Collections.sort(phonesList);
        String phonesStr = "[" + String.join((CharSequence)", ", phonesList) + "]";
        return name + "; " + emailsStr + "; " + phonesStr;
    }

    public static PCollection<String> coGroupByKeyTuple(final TupleTag<String> emailsTag, final TupleTag<String> phonesTag, PCollection<KV<String, String>> emails, PCollection<KV<String, String>> phones) {
        PCollection results = (PCollection)KeyedPCollectionTuple.of(emailsTag, emails).and(phonesTag, phones).apply((PTransform)CoGroupByKey.create());
        PCollection contactLines = (PCollection)results.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<String, CoGbkResult>, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                KV e = (KV)c.element();
                String name = (String)e.getKey();
                Iterable emailsIter = ((CoGbkResult)e.getValue()).getAll(emailsTag);
                Iterable phonesIter = ((CoGbkResult)e.getValue()).getAll(phonesTag);
                String formattedResult = Snippets.formatCoGbkResults(name, emailsIter, phonesIter);
                c.output((Object)formattedResult);
            }
        }));
        return contactLines;
    }

    public static void fileProcessPattern() throws Exception {
        Pipeline p = Pipeline.create();
        p.apply((PTransform)FileIO.match().filepattern("...").continuously(Duration.standardSeconds((long)30L), (Watch.Growth.TerminationCondition)Watch.Growth.afterTimeSinceNewOutput((ReadableDuration)Duration.standardHours((long)1L))));
        p.apply((PTransform)TextIO.read().from("<path-to-files>/*").watchForNewFiles(Duration.standardMinutes((long)1L), (Watch.Growth.TerminationCondition)Watch.Growth.afterTimeSinceNewOutput((ReadableDuration)Duration.standardHours((long)1L))));
        ((PCollection)((PCollection)p.apply((PTransform)FileIO.match().filepattern("hdfs://path/to/*.gz"))).apply((PTransform)FileIO.readMatches().withCompression(Compression.GZIP))).apply((PTransform)ParDo.of((DoFn)new DoFn<FileIO.ReadableFile, String>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element FileIO.ReadableFile file) {
                LOG.info("File Metadata resourceId is {} ", (Object)file.getMetadata().resourceId());
            }
        }));
    }

    public static void sideInputPatterns() {
        Pipeline p = Pipeline.create();
        final PCollectionView map = (PCollectionView)((PCollection)((PCollection)((PCollection)p.apply((PTransform)GenerateSequence.from((long)0L).withRate(1L, Duration.standardSeconds((long)5L)))).apply((PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterProcessingTime.pastFirstElementInPane())).discardingFiredPanes())).apply((PTransform)ParDo.of((DoFn)new DoFn<Long, Map<String, String>>(){

            @DoFn.ProcessElement
            public void process(@DoFn.Element Long input, DoFn.OutputReceiver<Map<String, String>> o) {
                o.output(PlaceholderExternalService.readTestData());
            }
        }))).apply((PTransform)View.asSingleton());
        ((PCollection)((PCollection)((PCollection)p.apply((PTransform)GenerateSequence.from((long)0L).withRate(1L, Duration.standardSeconds((long)1L)))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardSeconds((long)1L))))).apply((PTransform)Sum.longsGlobally().withoutDefaults())).apply((PTransform)ParDo.of((DoFn)new DoFn<Long, KV<Long, Long>>(){

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c) {
                Map keyMap = (Map)c.sideInput(map);
                c.outputWithTimestamp((Object)KV.of((Object)1L, (Object)((Long)c.element())), Instant.now());
                LOG.debug("Value is {}, key A is {}, and key B is {}.", new Object[]{c.element(), keyMap.get("Key_A"), keyMap.get("Key_B")});
            }
        }).withSideInputs(new PCollectionView[]{map}));
    }

    public static void accessingValueProviderInfoAfterRunSnip1(String[] args) {
        MyOptions options = (MyOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(MyOptions.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply((PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>(){

            @DoFn.ProcessElement
            public void process(DoFn.ProcessContext c) {
                MyOptions ops = (MyOptions)c.getPipelineOptions().as(MyOptions.class);
                LOG.info("Option StringValue was {}", ops.getStringValue());
            }
        }));
        ((PCollection)p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4}))).apply((PTransform)Sum.integersGlobally());
        p.run();
    }

    public Collection<IntervalWindow> assignWindows(WindowFn.AssignContext c) {
        return Arrays.asList(new IntervalWindow(c.timestamp(), (ReadableDuration)gapDuration));
    }

    private static class SplittableDoFn {
        private SplittableDoFn() {
        }

        private static void seekToNextRecordBoundaryInFile(RandomAccessFile file, long initialPosition) {
        }

        private static Integer readNextRecord(RandomAccessFile file) {
            return null;
        }

        private static class GetSizeExample
        extends DoFn<String, Integer> {
            private GetSizeExample() {
            }

            @DoFn.GetSize
            double getSize(@DoFn.Element String fileName, @DoFn.Restriction OffsetRange restriction) {
                return (long)(fileName.contains("expensiveRecords") ? 2 : 1) * restriction.getTo() - restriction.getFrom();
            }
        }

        private static class TruncateExample
        extends DoFn<String, Integer> {
            private TruncateExample() {
            }

            @DoFn.TruncateRestriction
            @Nullable
            RestrictionTracker.TruncateResult<OffsetRange> truncateRestriction(@DoFn.Element String fileName, @DoFn.Restriction OffsetRange restriction) {
                if (fileName.contains("optional")) {
                    return null;
                }
                return RestrictionTracker.TruncateResult.of((Object)restriction);
            }
        }

        private static class UserInitiatedCheckpointExample
        extends DoFn<String, Integer> {
            private UserInitiatedCheckpointExample() {
            }

            private Service initializeService() {
                return null;
            }

            @DoFn.ProcessElement
            public DoFn.ProcessContinuation processElement(RestrictionTracker<OffsetRange, Long> tracker, DoFn.OutputReceiver<Record> outputReceiver) {
                long currentPosition = ((OffsetRange)tracker.currentRestriction()).getFrom();
                Service service = this.initializeService();
                try {
                    block2: while (true) {
                        List<Record> records;
                        if ((records = service.readNextRecords(currentPosition)).isEmpty()) {
                            return DoFn.ProcessContinuation.resume().withResumeDelay(Duration.standardSeconds((long)10L));
                        }
                        Iterator<Record> iterator = records.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            Record record = iterator.next();
                            if (!tracker.tryClaim((Object)record.getPosition())) {
                                return DoFn.ProcessContinuation.stop();
                            }
                            currentPosition = record.getPosition() + 1L;
                            outputReceiver.output((Object)record);
                        }
                        break;
                    }
                }
                catch (ThrottlingException exception) {
                    return DoFn.ProcessContinuation.resume().withResumeDelay(Duration.standardSeconds((long)60L));
                }
            }

            public static interface Record {
                public long getPosition();
            }

            public static interface Service {
                public List<Record> readNextRecords(long var1) throws ThrottlingException;
            }

            public static class ElementNotReadyException
            extends Exception {
            }

            public static class ThrottlingException
            extends Exception {
            }
        }

        private static class CustomWatermarkEstimatorExample
        extends DoFn<String, Integer> {
            private static Instant currentWatermark = Instant.now();

            private CustomWatermarkEstimatorExample() {
            }

            @DoFn.GetWatermarkEstimatorStateCoder
            public Coder<MyCustomWatermarkState> getWatermarkEstimatorStateCoder() {
                return AvroCoder.of(MyCustomWatermarkState.class);
            }

            @DoFn.GetInitialWatermarkEstimatorState
            public MyCustomWatermarkState getInitialWatermarkEstimatorState(@DoFn.Element String element, @DoFn.Restriction OffsetRange restriction) {
                return new MyCustomWatermarkState(element, restriction);
            }

            @DoFn.NewWatermarkEstimator
            public WatermarkEstimator<MyCustomWatermarkState> newWatermarkEstimator(@DoFn.WatermarkEstimatorState MyCustomWatermarkState oldState) {
                return new MyCustomWatermarkEstimator(oldState);
            }

            public static class MyCustomWatermarkEstimator
            implements TimestampObservingWatermarkEstimator<MyCustomWatermarkState> {
                public MyCustomWatermarkEstimator(MyCustomWatermarkState type) {
                }

                public void observeTimestamp(Instant timestamp) {
                }

                public Instant currentWatermark() {
                    return currentWatermark;
                }

                public MyCustomWatermarkState getState() {
                    return null;
                }
            }

            public static class MyCustomWatermarkState {
                public MyCustomWatermarkState(String element, OffsetRange restriction) {
                }
            }
        }

        private static class BasicExampleWithBadTryClaimLoop
        extends DoFn<String, Integer> {
            private BasicExampleWithBadTryClaimLoop() {
            }

            @DoFn.ProcessElement
            public void badTryClaimLoop(@DoFn.Element String fileName, RestrictionTracker<OffsetRange, Long> tracker, DoFn.OutputReceiver<Integer> outputReceiver) throws IOException {
                RandomAccessFile file = new RandomAccessFile(fileName, "r");
                SplittableDoFn.seekToNextRecordBoundaryInFile(file, ((OffsetRange)tracker.currentRestriction()).getFrom());
                long end = ((OffsetRange)tracker.currentRestriction()).getTo();
                while (file.getFilePointer() < end) {
                    tracker.tryClaim((Object)file.getFilePointer());
                    outputReceiver.output((Object)SplittableDoFn.readNextRecord(file));
                }
            }
        }

        private static class BasicExampleWithInitialSplitting
        extends FileToWordsFn {
            private BasicExampleWithInitialSplitting() {
            }

            void splitRestriction(@DoFn.Restriction OffsetRange restriction, DoFn.OutputReceiver<OffsetRange> splitReceiver) {
                long splitSize = 0x4000000L;
                long i = restriction.getFrom();
                while (i < restriction.getTo() - splitSize) {
                    long end = i + splitSize;
                    splitReceiver.output((Object)new OffsetRange(i, end));
                    i = end;
                }
                splitReceiver.output((Object)new OffsetRange(i, restriction.getTo()));
            }
        }

        @DoFn.BoundedPerElement
        private static class FileToWordsFn
        extends DoFn<String, Integer> {
            private FileToWordsFn() {
            }

            @DoFn.GetInitialRestriction
            public OffsetRange getInitialRestriction(@DoFn.Element String fileName) throws IOException {
                return new OffsetRange(0L, new File(fileName).length());
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element String fileName, RestrictionTracker<OffsetRange, Long> tracker, DoFn.OutputReceiver<Integer> outputReceiver) throws IOException {
                RandomAccessFile file = new RandomAccessFile(fileName, "r");
                SplittableDoFn.seekToNextRecordBoundaryInFile(file, ((OffsetRange)tracker.currentRestriction()).getFrom());
                while (tracker.tryClaim((Object)file.getFilePointer())) {
                    outputReceiver.output((Object)SplittableDoFn.readNextRecord(file));
                }
            }

            @DoFn.GetRestrictionCoder
            public Coder<OffsetRange> getRestrictionCoder() {
                return OffsetRange.Coder.of();
            }
        }
    }

    private static class BundleFinalization {
        private BundleFinalization() {
        }

        private static class BundleFinalizationDoFn
        extends DoFn<String, Integer> {
            private BundleFinalizationDoFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c, DoFn.BundleFinalizer bundleFinalizer) {
                bundleFinalizer.afterBundleCommit(Instant.now().plus((ReadableDuration)Duration.standardMinutes((long)5L)), () -> {});
            }
        }
    }

    public static class NaturalLanguageIntegration {
        private static final SerializableFunction<AnnotateTextResponse, List<Map<String, List<String>>>> analyzeDependencyTree = (SerializableFunction & Serializable)response -> {
            ArrayList adjacencyLists = new ArrayList();
            int index = 0;
            for (Sentence s : response.getSentencesList()) {
                HashMap<String, List> adjacencyMap = new HashMap<String, List>();
                int sentenceBegin = s.getText().getBeginOffset();
                int sentenceEnd = sentenceBegin + s.getText().getContent().length() - 1;
                while (index < response.getTokensCount() && response.getTokens(index).getText().getBeginOffset() <= sentenceEnd) {
                    Token token = (Token)response.getTokensList().get(index);
                    int headTokenIndex = token.getDependencyEdge().getHeadTokenIndex();
                    String headTokenContent = response.getTokens(headTokenIndex).getText().getContent();
                    List adjacencyList = adjacencyMap.getOrDefault(headTokenContent, new ArrayList());
                    adjacencyList.add(token.getText().getContent());
                    adjacencyMap.put(headTokenContent, adjacencyList);
                    ++index;
                }
                adjacencyLists.add(adjacencyMap);
            }
            return adjacencyLists;
        };
        private static final SerializableFunction<? super AnnotateTextResponse, TextSentiments> extractSentiments = (SerializableFunction & Serializable)annotateTextResponse -> {
            TextSentiments sentiments = new TextSentiments();
            sentiments.setDocumentSentiment(Float.valueOf(annotateTextResponse.getDocumentSentiment().getMagnitude()));
            Map<String, Float> sentenceSentimentsMap = annotateTextResponse.getSentencesList().stream().collect(Collectors.toMap(s -> s.getText().getContent(), s -> Float.valueOf(s.getSentiment().getMagnitude())));
            sentiments.setSentenceSentiments(sentenceSentimentsMap);
            return sentiments;
        };
        private static final SerializableFunction<? super AnnotateTextResponse, Map<String, String>> extractEntities = (SerializableFunction & Serializable)annotateTextResponse -> annotateTextResponse.getEntitiesList().stream().collect(Collectors.toMap(Entity::getName, e -> e.getType().toString()));
        private static final SerializableFunction<? super Map<String, String>, String> mapEntitiesToJson = (SerializableFunction & Serializable)item -> {
            StringBuilder builder = new StringBuilder("[");
            builder.append(item.entrySet().stream().map(entry -> "{\"" + (String)entry.getKey() + "\": \"" + (String)entry.getValue() + "\"}").collect(Collectors.joining(",")));
            builder.append("]");
            return builder.toString();
        };
        private static final SerializableFunction<List<Map<String, List<String>>>, String> mapDependencyTreesToJson = (SerializableFunction & Serializable)tree -> {
            Gson gson = new Gson();
            return gson.toJson(tree);
        };

        public static void main(Pipeline p) {
            AnnotateTextRequest.Features features = AnnotateTextRequest.Features.newBuilder().setExtractEntities(true).setExtractDocumentSentiment(true).setExtractEntitySentiment(true).setExtractSyntax(true).build();
            AnnotateText annotateText = AnnotateText.newBuilder().setFeatures(features).build();
            PCollection responses = (PCollection)((PCollection)((PCollection)p.apply((PTransform)Create.of((Object)"My experience so far has been fantastic, I'd really recommend this product.", (Object[])new String[0]))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Document.class)).via((SerializableFunction & Serializable)input -> Document.newBuilder().setContent(input).setType(Document.Type.PLAIN_TEXT).build()))).apply((PTransform)annotateText);
            ((PCollection)((PCollection)responses.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(TextSentiments.class)).via(extractSentiments))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(TextSentiments::toJson))).apply((PTransform)TextIO.write().to("sentiments.txt"));
            ((PCollection)((PCollection)responses.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.maps((TypeDescriptor)TypeDescriptors.strings(), (TypeDescriptor)TypeDescriptors.strings())).via(extractEntities))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(mapEntitiesToJson))).apply((PTransform)TextIO.write().to("entities.txt"));
            ((PCollection)((PCollection)responses.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.lists((TypeDescriptor)TypeDescriptors.maps((TypeDescriptor)TypeDescriptors.strings(), (TypeDescriptor)TypeDescriptors.lists((TypeDescriptor)TypeDescriptors.strings())))).via(analyzeDependencyTree))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(mapDependencyTreesToJson))).apply((PTransform)TextIO.write().to("adjacency_list.txt"));
        }

        private static class TextSentiments
        implements Serializable {
            private Float documentSentiment;
            private Map<String, Float> sentenceSentiments;

            private TextSentiments() {
            }

            public void setSentenceSentiments(Map<String, Float> sentenceSentiments) {
                this.sentenceSentiments = sentenceSentiments;
            }

            public Float getDocumentSentiment() {
                return this.documentSentiment;
            }

            public void setDocumentSentiment(Float documentSentiment) {
                this.documentSentiment = documentSentiment;
            }

            public Map<String, Float> getSentenceSentiments() {
                return this.sentenceSentiments;
            }

            public String toJson() {
                Gson gson = new Gson();
                return gson.toJson((Object)this);
            }
        }
    }

    public static class SchemaJoinPattern {
        public static PCollection<String> main(Pipeline p, List<Row> emailUsers, List<Row> phoneUsers, Schema emailSchema, Schema phoneSchema) {
            PCollection emailList = (PCollection)p.apply("CreateEmails", (PTransform)Create.of(emailUsers).withRowSchema(emailSchema));
            PCollection phoneList = (PCollection)p.apply("CreatePhones", (PTransform)Create.of(phoneUsers).withRowSchema(phoneSchema));
            PCollection resultRow = (PCollection)emailList.apply("Apply Join", (PTransform)Join.innerJoin((PCollection)phoneList).using(new String[]{"name"}));
            resultRow.apply("Preview Result", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> {
                System.out.println(x);
                return "";
            }));
            PCollection result = (PCollection)resultRow.apply("Format Output", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> {
                String userInfo = "Name: " + x.getRow(0).getValue("name") + " Email: " + x.getRow(0).getValue("email") + " Phone: " + x.getRow(1).getValue("phone");
                System.out.println(userInfo);
                return userInfo;
            }));
            return result;
        }
    }

    public static class PeriodicallyUpdatingSideInputs {
        public static PCollection<Long> main(Pipeline p, Instant startAt, Instant stopAt, Duration interval1, Duration interval2, final String fileToRead) {
            final PCollectionView sideInput = (PCollectionView)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)p.apply("SIImpulse", (PTransform)PeriodicImpulse.create().startAt(startAt).stopAt(stopAt).withInterval(interval1).applyWindowing())).apply("FileToRead", (PTransform)ParDo.of((DoFn)new DoFn<Instant, String>(){

                @DoFn.ProcessElement
                public void process(@DoFn.Element Instant notUsed, DoFn.OutputReceiver<String> o) {
                    o.output((Object)fileToRead);
                }
            }))).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches())).apply((PTransform)TextIO.readFiles())).apply((PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void process(@DoFn.Element String src, DoFn.OutputReceiver<String> o) {
                    o.output((Object)src);
                }
            }))).apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)Count.combineFn()).withoutDefaults())).apply((PTransform)View.asList());
            PCollection mainInput = (PCollection)p.apply("MIImpulse", (PTransform)PeriodicImpulse.create().startAt(startAt.minus((ReadableDuration)Duration.standardSeconds((long)1L))).stopAt(stopAt.minus((ReadableDuration)Duration.standardSeconds((long)1L))).withInterval(interval2).applyWindowing());
            PCollection result = (PCollection)mainInput.apply("generateOutput", (PTransform)ParDo.of((DoFn)new DoFn<Instant, Long>(){

                @DoFn.ProcessElement
                public void process(DoFn.ProcessContext c) {
                    c.output((Object)((List)c.sideInput(sideInput)).size());
                }
            }).withSideInputs(new PCollectionView[]{sideInput}));
            return result;
        }
    }

    public static class DeadLetterBigQuery {
        public static void main(String[] args) {
            PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(BigQueryOptions.class);
            Pipeline p = Pipeline.create((PipelineOptions)options);
            WriteResult result = (WriteResult)((PCollection)p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2}))).apply((PTransform)BigQueryIO.write().withSchema(new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("num").setType("INTEGER").setMode("REQUIRED")))).to("Test.dummyTable").withFormatFunction((SerializableFunction & Serializable)x -> new TableRow().set("num", (Object)(x == 2 ? null : x))).withFailedInsertRetryPolicy(InsertRetryPolicy.retryTransientErrors()).withMethod(BigQueryIO.Write.Method.STREAMING_INSERTS).withExtendedErrorInfo().withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND));
            result.getFailedInsertsWithErr().apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> {
                System.out.println(" The table was " + x.getTable());
                System.out.println(" The row was " + x.getRow());
                System.out.println(" The error was " + x.getError());
                return "";
            }));
            p.run();
        }
    }

    public static class CustomSessionPipeline {
        public static void main(String[] args) {
            PCollection p = (PCollection)Pipeline.create().apply("Create data", (PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)new TableRow().set("user", (Object)"mobile").set("score", (Object)12).set("gap", (Object)5), (Instant)new Instant()), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)new TableRow().set("user", (Object)"desktop").set("score", (Object)4), (Instant)new Instant()), TimestampedValue.of((Object)new TableRow().set("user", (Object)"mobile").set("score", (Object)-3).set("gap", (Object)5), (Instant)new Instant().plus(2000L)), TimestampedValue.of((Object)new TableRow().set("user", (Object)"mobile").set("score", (Object)2).set("gap", (Object)5), (Instant)new Instant().plus(9000L)), TimestampedValue.of((Object)new TableRow().set("user", (Object)"mobile").set("score", (Object)7).set("gap", (Object)5), (Instant)new Instant().plus(12000L)), TimestampedValue.of((Object)new TableRow().set("user", (Object)"desktop").set("score", (Object)10), (Instant)new Instant().plus(12000L))}));
            p.apply("Window into sessions", (PTransform)Window.into((WindowFn)DynamicSessions.withDefaultGapDuration(Duration.standardSeconds((long)10L))));
        }
    }

    public static class DynamicSessions
    extends WindowFn<TableRow, IntervalWindow> {
        private final Duration gapDuration;

        private DynamicSessions(Duration gapDuration) {
            this.gapDuration = gapDuration;
        }

        public Collection<IntervalWindow> assignWindows(WindowFn.AssignContext c) {
            Duration dataDrivenGap;
            TableRow message = (TableRow)c.element();
            try {
                dataDrivenGap = Duration.standardSeconds((long)Long.parseLong(message.get((Object)"gap").toString()));
            }
            catch (Exception e) {
                dataDrivenGap = this.gapDuration;
            }
            return Arrays.asList(new IntervalWindow(c.timestamp(), (ReadableDuration)dataDrivenGap));
        }

        public static DynamicSessions withDefaultGapDuration(Duration gapDuration) {
            return new DynamicSessions(gapDuration);
        }

        public void mergeWindows(WindowFn.MergeContext c) throws Exception {
        }

        public boolean isCompatible(WindowFn<?, ?> other) {
            return false;
        }

        public Coder<IntervalWindow> windowCoder() {
            return null;
        }

        public WindowMappingFn<IntervalWindow> getDefaultWindowMappingFn() {
            return null;
        }
    }

    public static interface MyOptions
    extends PipelineOptions {
        @Description(value="My option")
        @Default.String(value="Hello world!")
        public ValueProvider<String> getStringValue();

        public void setStringValue(ValueProvider<String> var1);
    }

    public static class PlaceholderExternalService {
        public static Map<String, String> readTestData() {
            HashMap<String, String> map = new HashMap<String, String>();
            Instant now = Instant.now();
            DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"HH:MM:SS");
            map.put("Key_A", now.minus((ReadableDuration)Duration.standardSeconds((long)30L)).toString(dtf));
            map.put("Key_B", now.minus((ReadableDuration)Duration.standardSeconds((long)30L)).toString());
            return map;
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    static class WeatherData {
        final long year;
        final long month;
        final long day;
        final double maxTemp;

        public WeatherData() {
            this.year = 0L;
            this.month = 0L;
            this.day = 0L;
            this.maxTemp = 0.0;
        }

        public WeatherData(long year, long month, long day, double maxTemp) {
            this.year = year;
            this.month = month;
            this.day = day;
            this.maxTemp = maxTemp;
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    static class Quote {
        final String source;
        final String quote;

        public Quote() {
            this.source = "";
            this.quote = "";
        }

        public Quote(String source, String quote) {
            this.source = source;
            this.quote = quote;
        }
    }
}

