/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.examples.complete.TrafficMaxLaneFlow;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.io.gcp.testing.BigqueryClient;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.util.FluentBackoff;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TrafficMaxLaneFlowIT {
    private TrafficMaxLaneFlow.TrafficMaxLaneFlowOptions options;
    private final String timestamp = Long.toString(System.currentTimeMillis());
    private final String outputDatasetId = "traffic_max_lane_flow_" + this.timestamp;
    private final String outputTable = "traffic_max_lane_flow_table";
    private String projectId;
    private BigqueryClient bqClient;

    @Before
    public void setupTestEnvironment() throws Exception {
        PipelineOptionsFactory.register(TrafficMaxLaneFlow.TrafficMaxLaneFlowOptions.class);
        this.options = (TrafficMaxLaneFlow.TrafficMaxLaneFlowOptions)TestPipeline.testingPipelineOptions().as(TrafficMaxLaneFlow.TrafficMaxLaneFlowOptions.class);
        this.projectId = ((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject();
        this.bqClient = new BigqueryClient("TrafficMaxLaneFlowIT");
        this.bqClient.createNewDataset(this.projectId, this.outputDatasetId);
    }

    @After
    public void cleanupTestEnvironment() {
        this.bqClient.deleteDataset(this.projectId, this.outputDatasetId);
    }

    @Test
    public void testE2ETrafficMaxLaneFlow() throws Exception {
        this.options.setBigQuerySchema(TrafficMaxLaneFlow.FormatMaxesFn.getSchema());
        this.options.setProject(this.projectId);
        this.options.setBigQueryDataset(this.outputDatasetId);
        this.options.setBigQueryTable(this.outputTable);
        TrafficMaxLaneFlow.runTrafficMaxLaneFlow((TrafficMaxLaneFlow.TrafficMaxLaneFlowOptions)this.options);
        FluentBackoff backoffFactory = FluentBackoff.DEFAULT.withMaxRetries(4).withInitialBackoff(Duration.standardSeconds((long)1L));
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)backoffFactory.backoff());
        String res = "empty_result";
        while (true) {
            QueryResponse response = this.bqClient.queryWithRetries(String.format("SELECT count(*) as total FROM [%s:%s.%s]", this.projectId, this.outputDatasetId, this.outputTable), this.projectId);
            try {
                res = ((TableCell)((TableRow)response.getRows().get(0)).getF().get(0)).getV().toString();
            }
            catch (NullPointerException nullPointerException) {
                if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) continue;
            }
            break;
        }
        Assert.assertEquals((Object)"9763", (Object)res);
    }
}

