/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.examples.complete.game.GameStats;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GameStatsTest
implements Serializable {
    static final List<KV<String, Integer>> USER_SCORES = Arrays.asList(KV.of((Object)"Robot-2", (Object)66), KV.of((Object)"Robot-1", (Object)116), KV.of((Object)"user7_AndroidGreenKookaburra", (Object)23), KV.of((Object)"user7_AndroidGreenKookaburra", (Object)1), KV.of((Object)"user19_BisqueBilby", (Object)14), KV.of((Object)"user13_ApricotQuokka", (Object)15), KV.of((Object)"user18_BananaEmu", (Object)25), KV.of((Object)"user6_AmberEchidna", (Object)8), KV.of((Object)"user2_AmberQuokka", (Object)6), KV.of((Object)"user0_MagentaKangaroo", (Object)4), KV.of((Object)"user0_MagentaKangaroo", (Object)3), KV.of((Object)"user2_AmberCockatoo", (Object)13), KV.of((Object)"user7_AlmondWallaby", (Object)15), KV.of((Object)"user6_AmberNumbat", (Object)11), KV.of((Object)"user6_AmberQuokka", (Object)4));
    static final List<KV<String, Integer>> SPAMMERS = Arrays.asList(KV.of((Object)"Robot-2", (Object)66), KV.of((Object)"Robot-1", (Object)116));
    @Rule
    public TestPipeline p = TestPipeline.create();

    @Test
    @Category(value={ValidatesRunner.class})
    public void testCalculateSpammyUsers() throws Exception {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(USER_SCORES));
        PCollection output = (PCollection)input.apply((PTransform)new GameStats.CalculateSpammyUsers());
        PAssert.that((PCollection)output).containsInAnyOrder(SPAMMERS);
        this.p.run().waitUntilFinish();
    }

    @Test
    public void testGameStatsOptions() {
        PipelineOptionsFactory.as(GameStats.Options.class);
    }
}

