/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.transforms.io;

import java.io.Serializable;
import org.apache.beam.examples.complete.datatokenization.options.DataTokenizationOptions;
import org.apache.beam.examples.complete.datatokenization.transforms.JsonToBeamRow;
import org.apache.beam.examples.complete.datatokenization.transforms.SerializableFunctions;
import org.apache.beam.examples.complete.datatokenization.utils.CsvConverters;
import org.apache.beam.examples.complete.datatokenization.utils.ErrorConverters;
import org.apache.beam.examples.complete.datatokenization.utils.FailsafeElement;
import org.apache.beam.examples.complete.datatokenization.utils.RowToCsv;
import org.apache.beam.examples.complete.datatokenization.utils.SchemasUtils;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.ToJson;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;

public class TokenizationFileSystemIO {
    static final TupleTag<String> CSV_HEADERS = new TupleTag<String>(){};
    static final TupleTag<String> CSV_LINES = new TupleTag<String>(){};
    static final TupleTag<FailsafeElement<String, String>> PROCESSING_DEADLETTER_OUT = new TupleTag<FailsafeElement<String, String>>(){};
    static final TupleTag<FailsafeElement<String, String>> PROCESSING_OUT = new TupleTag<FailsafeElement<String, String>>(){};
    private final DataTokenizationOptions options;

    public TokenizationFileSystemIO(DataTokenizationOptions options) {
        this.options = options;
    }

    public PCollection<Row> read(Pipeline pipeline, SchemasUtils schema) {
        switch (this.options.getInputFileFormat()) {
            case JSON: {
                return (PCollection)this.readJson(pipeline).apply((PTransform)new JsonToBeamRow(this.options.getNonTokenizedDeadLetterPath(), schema));
            }
            case CSV: {
                return (PCollection)this.readCsv(pipeline, schema).apply((PTransform)new JsonToBeamRow(this.options.getNonTokenizedDeadLetterPath(), schema));
            }
        }
        throw new IllegalStateException("No valid format for input data is provided. Please, choose JSON or CSV.");
    }

    private PCollection<String> readJson(Pipeline pipeline) {
        return (PCollection)pipeline.apply("ReadJsonFromFiles", (PTransform)TextIO.read().from(this.options.getInputFilePattern()));
    }

    private PCollection<String> readCsv(Pipeline pipeline, SchemasUtils schema) {
        PCollectionTuple csvLines = this.readCsv(pipeline);
        PCollectionTuple jsons = this.csvLineToJson(csvLines, schema.getJsonBeamSchema());
        if (this.options.getNonTokenizedDeadLetterPath() != null) {
            jsons.get(PROCESSING_DEADLETTER_OUT).apply("WriteCsvConversionErrorsToFS", ErrorConverters.WriteErrorsToTextIO.newBuilder().setErrorWritePath(this.options.getNonTokenizedDeadLetterPath()).setTranslateFunction(SerializableFunctions.getCsvErrorConverter()).build());
        }
        return (PCollection)jsons.get(PROCESSING_OUT).apply("GetJson", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(FailsafeElement::getPayload));
    }

    private PCollectionTuple readCsv(Pipeline pipeline) {
        return (PCollectionTuple)pipeline.apply("ReadCsvFromFiles", (PTransform)CsvConverters.ReadCsv.newBuilder().setCsvFormat(this.options.getCsvFormat()).setDelimiter(this.options.getCsvDelimiter()).setHasHeaders(this.options.getCsvContainsHeaders()).setInputFileSpec(this.options.getInputFilePattern()).setHeaderTag(CSV_HEADERS).setLineTag(CSV_LINES).build());
    }

    private PCollectionTuple csvLineToJson(PCollectionTuple csvLines, String jsonSchema) {
        return (PCollectionTuple)csvLines.apply("LineToJson", (PTransform)CsvConverters.LineToFailsafeJson.newBuilder().setDelimiter(this.options.getCsvDelimiter()).setJsonSchema(jsonSchema).setHeaderTag(CSV_HEADERS).setLineTag(CSV_LINES).setUdfOutputTag(PROCESSING_OUT).setUdfDeadletterTag(PROCESSING_DEADLETTER_OUT).build());
    }

    public PDone write(PCollection<Row> input, Schema schema) {
        switch (this.options.getOutputFileFormat()) {
            case JSON: {
                return this.writeJson(input);
            }
            case CSV: {
                return this.writeCsv(input, schema);
            }
        }
        throw new IllegalStateException("No valid format for output data is provided. Please, choose JSON or CSV.");
    }

    private PDone writeJson(PCollection<Row> input) {
        PCollection jsons = (PCollection)input.apply("RowsToJSON", (PTransform)ToJson.of());
        if (jsons.isBounded() == PCollection.IsBounded.BOUNDED) {
            return (PDone)jsons.apply("WriteToFS", (PTransform)TextIO.write().to(this.options.getOutputDirectory()));
        }
        return (PDone)jsons.apply("WriteToFS", (PTransform)TextIO.write().withWindowedWrites().withNumShards(1).to(this.options.getOutputDirectory()));
    }

    private PDone writeCsv(PCollection<Row> input, Schema schema) {
        String header = String.join((CharSequence)this.options.getCsvDelimiter(), schema.getFieldNames());
        String csvDelimiter = this.options.getCsvDelimiter();
        PCollection csvs = (PCollection)input.apply("ConvertToCSV", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)inputRow -> new RowToCsv(csvDelimiter).getCsvFromRow((Row)inputRow)));
        if (csvs.isBounded() == PCollection.IsBounded.BOUNDED) {
            return (PDone)csvs.apply("WriteToFS", (PTransform)TextIO.write().to(this.options.getOutputDirectory()).withHeader(header));
        }
        return (PDone)csvs.apply("WriteToFS", (PTransform)TextIO.write().withWindowedWrites().withNumShards(1).to(this.options.getOutputDirectory()).withHeader(header));
    }

    public static interface FileSystemPipelineOptions
    extends PipelineOptions {
        @Description(value="Filepattern for files to read data from")
        public String getInputFilePattern();

        public void setInputFilePattern(String var1);

        @Description(value="File format of input files. Supported formats: JSON, CSV")
        @Default.Enum(value="JSON")
        public FORMAT getInputFileFormat();

        public void setInputFileFormat(FORMAT var1);

        @Description(value="Directory to write data to")
        public String getOutputDirectory();

        public void setOutputDirectory(String var1);

        @Description(value="File format of output files. Supported formats: JSON, CSV")
        @Default.Enum(value="JSON")
        public FORMAT getOutputFileFormat();

        public void setOutputFileFormat(FORMAT var1);

        @Description(value="The window duration in which data will be written. Should be specified only for 'Pub/Sub -> FS' case. Defaults to 30s. Allowed formats are: Ns (for seconds, example: 5s), Nm (for minutes, example: 12m), Nh (for hours, example: 2h).")
        @Default.String(value="30s")
        public String getWindowDuration();

        public void setWindowDuration(String var1);

        @Description(value="If file(s) contain headers")
        public Boolean getCsvContainsHeaders();

        public void setCsvContainsHeaders(Boolean var1);

        @Description(value="Delimiting character in CSV. Default: use delimiter provided in csvFormat")
        @Default.InstanceFactory(value=CsvConverters.DelimiterFactory.class)
        public String getCsvDelimiter();

        public void setCsvDelimiter(String var1);

        @Description(value="Csv format according to Apache Commons CSV format. Default is: Apache Commons CSV default\nhttps://static.javadoc.io/org.apache.commons/commons-csv/1.7/org/apache/commons/csv/CSVFormat.html#DEFAULT\nMust match format names exactly found at: https://static.javadoc.io/org.apache.commons/commons-csv/1.7/org/apache/commons/csv/CSVFormat.Predefined.html")
        @Default.String(value="Default")
        public String getCsvFormat();

        public void setCsvFormat(String var1);
    }

    public static enum FORMAT {
        JSON,
        CSV;

    }
}

