/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.utils;

import java.util.Locale;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.MutablePeriod;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadableInstant;
import org.joda.time.format.PeriodFormatterBuilder;
import org.joda.time.format.PeriodParser;

public class DurationUtils {
    public static Duration parseDuration(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"The specified duration must be a non-null value!");
        PeriodParser parser = new PeriodFormatterBuilder().appendSeconds().appendSuffix("s").appendMinutes().appendSuffix("m").appendHours().appendSuffix("h").toParser();
        MutablePeriod period = new MutablePeriod();
        parser.parseInto((ReadWritablePeriod)period, value, 0, Locale.getDefault());
        Duration duration = period.toDurationFrom((ReadableInstant)new DateTime(0L));
        Preconditions.checkArgument((duration.getMillis() > 0L ? 1 : 0) != 0, (Object)"The window duration must be greater than 0!");
        return duration;
    }
}

