/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.utils;

import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.CharStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemasUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SchemasUtils.class);
    private TableSchema bigQuerySchema;
    private Schema beamSchema;
    private String jsonBeamSchema;
    public static final String DEADLETTER_SCHEMA = "{\n  \"fields\": [\n    {\n      \"name\": \"timestamp\",\n      \"type\": \"TIMESTAMP\",\n      \"mode\": \"REQUIRED\"\n    },\n    {\n      \"name\": \"payloadString\",\n      \"type\": \"STRING\",\n      \"mode\": \"REQUIRED\"\n    },\n    {\n      \"name\": \"payloadBytes\",\n      \"type\": \"BYTES\",\n      \"mode\": \"REQUIRED\"\n    },\n    {\n      \"name\": \"attributes\",\n      \"type\": \"RECORD\",\n      \"mode\": \"REPEATED\",\n      \"fields\": [\n        {\n          \"name\": \"key\",\n          \"type\": \"STRING\",\n          \"mode\": \"NULLABLE\"\n        },\n        {\n          \"name\": \"value\",\n          \"type\": \"STRING\",\n          \"mode\": \"NULLABLE\"\n        }\n      ]\n    },\n    {\n      \"name\": \"errorMessage\",\n      \"type\": \"STRING\",\n      \"mode\": \"NULLABLE\"\n    },\n    {\n      \"name\": \"stacktrace\",\n      \"type\": \"STRING\",\n      \"mode\": \"NULLABLE\"\n    }\n  ]\n}";

    public SchemasUtils(String schema) {
        this.parseJson(schema);
    }

    public SchemasUtils(String path, Charset encoding) throws IOException {
        if (path.startsWith("gs://")) {
            this.parseJson(new String(SchemasUtils.readGcsFile(path), encoding));
        } else {
            byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
            this.parseJson(new String(encoded, encoding));
        }
        LOG.info("Extracted schema: " + this.bigQuerySchema.toPrettyString());
    }

    public TableSchema getBigQuerySchema() {
        return this.bigQuerySchema;
    }

    private void parseJson(String jsonSchema) throws UnsupportedOperationException {
        TableSchema schema = (TableSchema)BigQueryHelpers.fromJsonString((String)jsonSchema, TableSchema.class);
        this.validateSchemaTypes(schema);
        this.bigQuerySchema = schema;
        this.jsonBeamSchema = BigQueryHelpers.toJsonString((Object)schema.getFields());
    }

    private void validateSchemaTypes(TableSchema bigQuerySchema) {
        try {
            this.beamSchema = BigQueryUtils.fromTableSchema((TableSchema)bigQuerySchema);
        }
        catch (UnsupportedOperationException exception) {
            LOG.error("Check json schema, {}", (Object)exception.getMessage());
        }
        catch (NullPointerException npe) {
            LOG.error("Missing schema keywords, please check what all required fields presented");
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] readGcsFile(String gcsFilePath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Schema getBeamSchema() {
        return this.beamSchema;
    }

    public String getJsonBeamSchema() {
        return this.jsonBeamSchema;
    }

    public static String getGcsFileAsString(String filePath) {
        try {
            MatchResult result = FileSystems.match((String)filePath);
            Preconditions.checkArgument((result.status() == MatchResult.Status.OK && !result.metadata().isEmpty() ? 1 : 0) != 0, (Object)("Failed to match any files with the pattern: " + filePath));
            List rId = result.metadata().stream().map(MatchResult.Metadata::resourceId).collect(Collectors.toList());
            Preconditions.checkArgument((rId.size() == 1 ? 1 : 0) != 0, (Object)("Expected exactly 1 file, but got " + rId.size() + " files."));
            Reader reader = Channels.newReader(FileSystems.open((ResourceId)((ResourceId)rId.get(0))), StandardCharsets.UTF_8.name());
            return CharStreams.toString((Readable)reader);
        }
        catch (IOException ioe) {
            LOG.error("File system i/o error: " + ioe.getMessage());
            throw new RuntimeException(ioe);
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

