/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.subprocess.utils;

import org.apache.beam.examples.subprocess.configuration.SubProcessConfiguration;
import org.apache.beam.examples.subprocess.utils.FileUtils;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;

@DefaultCoder(value=AvroCoder.class)
public class ExecutableFile {
    String fileName;
    private String sourceGCSLocation;
    private String destinationLocation;

    public String getSourceGCSLocation() {
        return this.sourceGCSLocation;
    }

    public void setSourceGCSLocation(String sourceGCSLocation) {
        this.sourceGCSLocation = sourceGCSLocation;
    }

    public String getDestinationLocation() {
        return this.destinationLocation;
    }

    public void setDestinationLocation(String destinationLocation) {
        this.destinationLocation = destinationLocation;
    }

    public ExecutableFile(SubProcessConfiguration configuration, String fileName) throws IllegalStateException {
        if (configuration == null) {
            throw new IllegalStateException("Configuration can not be NULL");
        }
        if (fileName == null) {
            throw new IllegalStateException("FileName can not be NULLt");
        }
        this.fileName = fileName;
        this.setDestinationLocation(configuration);
        this.setSourceLocation(configuration);
    }

    private void setDestinationLocation(SubProcessConfiguration configuration) {
        this.sourceGCSLocation = FileUtils.getFileResourceId(configuration.getSourcePath(), this.fileName).toString();
    }

    private void setSourceLocation(SubProcessConfiguration configuration) {
        this.destinationLocation = FileUtils.getFileResourceId(configuration.getWorkerPath(), this.fileName).toString();
    }
}

