/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game.injector;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Sleeper;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.beam.examples.java.repackaged.com.google.common.base.Preconditions;

public class RetryHttpInitializerWrapper
implements HttpRequestInitializer {
    private static final Logger LOG = Logger.getLogger(RetryHttpInitializerWrapper.class.getName());
    private static final int ONEMINITUES = 60000;
    private final Credential wrappedCredential;
    private final Sleeper sleeper;

    public RetryHttpInitializerWrapper(Credential wrappedCredential) {
        this(wrappedCredential, Sleeper.DEFAULT);
    }

    RetryHttpInitializerWrapper(Credential wrappedCredential, Sleeper sleeper) {
        this.wrappedCredential = Preconditions.checkNotNull(wrappedCredential);
        this.sleeper = sleeper;
    }

    public final void initialize(HttpRequest request) {
        request.setReadTimeout(120000);
        HttpBackOffUnsuccessfulResponseHandler backoffHandler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff()).setSleeper(this.sleeper);
        request.setInterceptor((HttpExecuteInterceptor)this.wrappedCredential);
        request.setUnsuccessfulResponseHandler((arg_0, arg_1, arg_2) -> this.lambda$initialize$0((HttpUnsuccessfulResponseHandler)backoffHandler, arg_0, arg_1, arg_2));
        request.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff()).setSleeper(this.sleeper));
    }

    private /* synthetic */ boolean lambda$initialize$0(HttpUnsuccessfulResponseHandler backoffHandler, HttpRequest request1, HttpResponse response, boolean supportsRetry) throws IOException {
        if (this.wrappedCredential.handleResponse(request1, response, supportsRetry)) {
            return true;
        }
        if (backoffHandler.handleResponse(request1, response, supportsRetry)) {
            LOG.info("Retrying " + request1.getUrl().toString());
            return true;
        }
        return false;
    }
}

