/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.beam.examples.complete.datatokenization.options.DataTokenizationOptions;
import org.apache.beam.examples.complete.datatokenization.transforms.io.TokenizationFileSystemIO;
import org.apache.beam.examples.complete.datatokenization.utils.FailsafeElementCoder;
import org.apache.beam.examples.complete.datatokenization.utils.RowToCsv;
import org.apache.beam.examples.complete.datatokenization.utils.SchemasUtils;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.Resources;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DataTokenizationTest {
    private static final String testSchema = "{\"fields\":[{\"mode\":\"REQUIRED\",\"name\":\"FieldName1\",\"type\":\"STRING\"},{\"mode\":\"REQUIRED\",\"name\":\"FieldName2\",\"type\":\"STRING\"}]}";
    String[] fields = new String[]{"TestValue1", "TestValue2"};
    @Rule
    public final transient TestPipeline testPipeline = TestPipeline.create();
    private static final String RESOURCES_DIR = "./";
    private static final String CSV_FILE_PATH = Resources.getResource((String)"./testInput.csv").getPath();
    private static final String JSON_FILE_PATH = Resources.getResource((String)"./testInput.txt").getPath();
    private static final String SCHEMA_FILE_PATH = Resources.getResource((String)"./schema.txt").getPath();
    private static final FailsafeElementCoder<String, String> FAILSAFE_ELEMENT_CODER = FailsafeElementCoder.of((Coder)NullableCoder.of((Coder)StringUtf8Coder.of()), (Coder)NullableCoder.of((Coder)StringUtf8Coder.of()));

    @Test
    public void testGetBeamSchema() {
        Schema expectedSchema = Schema.builder().addField("FieldName1", Schema.FieldType.STRING).addField("FieldName2", Schema.FieldType.STRING).build();
        SchemasUtils schemasUtils = new SchemasUtils(testSchema);
        Assert.assertEquals((Object)expectedSchema, (Object)schemasUtils.getBeamSchema());
    }

    @Test
    public void testGetBigQuerySchema() {
        SchemasUtils schemasUtils = new SchemasUtils(testSchema);
        Assert.assertEquals((Object)testSchema, (Object)schemasUtils.getBigQuerySchema().toString());
    }

    @Test
    public void testRowToCSV() {
        Schema beamSchema = new SchemasUtils(testSchema).getBeamSchema();
        Row.Builder rowBuilder = Row.withSchema((Schema)beamSchema);
        Row row = rowBuilder.addValues(new ArrayList<String>(Arrays.asList(this.fields))).build();
        String csvResult = new RowToCsv(";").getCsvFromRow(row);
        Assert.assertEquals((Object)String.join((CharSequence)";", this.fields), (Object)csvResult);
    }

    @Test
    public void testRowToCSVWithNull() {
        String nullableTestSchema = "{\"fields\":[{\"mode\":\"REQUIRED\",\"name\":\"FieldName1\",\"type\":\"STRING\"},{\"mode\":\"NULLABLE\",\"name\":\"FieldName2\",\"type\":\"STRING\"}]}";
        String expectedCsv = "TestValueOne;null";
        ArrayList values = Lists.newArrayList((Object[])new Object[]{"TestValueOne", null});
        Schema beamSchema = new SchemasUtils("{\"fields\":[{\"mode\":\"REQUIRED\",\"name\":\"FieldName1\",\"type\":\"STRING\"},{\"mode\":\"NULLABLE\",\"name\":\"FieldName2\",\"type\":\"STRING\"}]}").getBeamSchema();
        Row.Builder rowBuilder = Row.withSchema((Schema)beamSchema);
        Row row = rowBuilder.addValues((List)values).build();
        String csvResult = new RowToCsv(";").getCsvFromRow(row);
        Assert.assertEquals((Object)"TestValueOne;null", (Object)csvResult);
    }

    @Test
    public void testFileSystemIOReadCSV() throws IOException {
        PCollection<Row> jsons = this.fileSystemIORead(CSV_FILE_PATH, TokenizationFileSystemIO.FORMAT.CSV);
        this.assertRows(jsons);
        this.testPipeline.run();
    }

    @Test
    public void testFileSystemIOReadJSON() throws IOException {
        PCollection<Row> jsons = this.fileSystemIORead(JSON_FILE_PATH, TokenizationFileSystemIO.FORMAT.JSON);
        this.assertRows(jsons);
        this.testPipeline.run();
    }

    @Test
    public void testJsonToRow() throws IOException {
        PCollection<Row> rows = this.fileSystemIORead(JSON_FILE_PATH, TokenizationFileSystemIO.FORMAT.JSON);
        PAssert.that(rows).satisfies((SerializableFunction & Serializable)x -> {
            LinkedList beamRows = Lists.newLinkedList((Iterable)x);
            MatcherAssert.assertThat((Object)beamRows, (Matcher)Matchers.hasSize((int)3));
            beamRows.forEach(row -> {
                List fieldValues = row.getValues();
                for (Object element : fieldValues) {
                    MatcherAssert.assertThat((Object)((String)element), (Matcher)Matchers.startsWith((String)"FieldValue"));
                }
            });
            return null;
        });
        this.testPipeline.run();
    }

    private PCollection<Row> fileSystemIORead(String inputGcsFilePattern, TokenizationFileSystemIO.FORMAT inputGcsFileFormat) throws IOException {
        DataTokenizationOptions options = (DataTokenizationOptions)PipelineOptionsFactory.create().as(DataTokenizationOptions.class);
        options.setDataSchemaPath(SCHEMA_FILE_PATH);
        options.setInputFilePattern(inputGcsFilePattern);
        options.setInputFileFormat(inputGcsFileFormat);
        if (inputGcsFileFormat == TokenizationFileSystemIO.FORMAT.CSV) {
            options.setCsvContainsHeaders(Boolean.FALSE);
        }
        SchemasUtils testSchemaUtils = new SchemasUtils(options.getDataSchemaPath(), StandardCharsets.UTF_8);
        CoderRegistry coderRegistry = this.testPipeline.getCoderRegistry();
        coderRegistry.registerCoderForType(FAILSAFE_ELEMENT_CODER.getEncodedTypeDescriptor(), FAILSAFE_ELEMENT_CODER);
        coderRegistry.registerCoderForType(RowCoder.of((Schema)testSchemaUtils.getBeamSchema()).getEncodedTypeDescriptor(), (Coder)RowCoder.of((Schema)testSchemaUtils.getBeamSchema()));
        FailsafeElementCoder coder = FailsafeElementCoder.of((Coder)RowCoder.of((Schema)testSchemaUtils.getBeamSchema()), (Coder)RowCoder.of((Schema)testSchemaUtils.getBeamSchema()));
        coderRegistry.registerCoderForType(coder.getEncodedTypeDescriptor(), (Coder)coder);
        return new TokenizationFileSystemIO(options).read((Pipeline)this.testPipeline, testSchemaUtils);
    }

    private void assertRows(PCollection<Row> jsons) {
        PAssert.that(jsons).satisfies((SerializableFunction & Serializable)x -> {
            LinkedList rows = Lists.newLinkedList((Iterable)x);
            MatcherAssert.assertThat((Object)rows, (Matcher)Matchers.hasSize((int)3));
            rows.forEach(row -> {
                Assert.assertNotNull((Object)row.getSchema());
                MatcherAssert.assertThat((Object)row.getSchema().getFields(), (Matcher)Matchers.hasSize((int)3));
                MatcherAssert.assertThat((Object)row.getSchema().getField(0).getName(), (Matcher)Matchers.equalTo((Object)"Field1"));
                MatcherAssert.assertThat((Object)row.getValues(), (Matcher)Matchers.hasSize((int)3));
            });
            return null;
        });
    }
}

