/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.examples.WordCount;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WordCountTest {
    static final String[] WORDS_ARRAY = new String[]{"hi there", "hi", "hi sue bob", "hi sue", "", "bob hi"};
    static final List<String> WORDS = Arrays.asList(WORDS_ARRAY);
    static final String[] COUNTS_ARRAY = new String[]{"hi: 5", "there: 1", "sue: 2", "bob: 2"};
    @Rule
    public TestPipeline p = TestPipeline.create();

    @Test
    public void testExtractWordsFn() throws Exception {
        List<String> words = Arrays.asList(" some  input  words ", " ", " cool ", " foo", " bar");
        PCollection output = (PCollection)((PCollection)this.p.apply((PTransform)Create.of(words).withCoder((Coder)StringUtf8Coder.of()))).apply((PTransform)ParDo.of((DoFn)new WordCount.ExtractWordsFn()));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"some", "input", "words", "cool", "foo", "bar"});
        this.p.run().waitUntilFinish();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testCountWords() throws Exception {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(WORDS).withCoder((Coder)StringUtf8Coder.of()));
        PCollection output = (PCollection)((PCollection)input.apply((PTransform)new WordCount.CountWords())).apply((PTransform)MapElements.via((SimpleFunction)new WordCount.FormatAsTextFn()));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])COUNTS_ARRAY);
        this.p.run().waitUntilFinish();
    }
}

