/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete;

import org.apache.beam.examples.complete.AutoComplete;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AutoCompleteIT {
    public static final String DEFAULT_INPUT = "gs://apache-beam-samples/shakespeare/kinglear-hashtag.txt";
    public static final Long DEFAULT_INPUT_CHECKSUM = -25447108232L;

    @BeforeClass
    public static void setUp() {
        PipelineOptionsFactory.register(TestPipelineOptions.class);
    }

    @Test
    public void testE2EAutoComplete() throws Exception {
        AutoCompleteITOptions options = (AutoCompleteITOptions)TestPipeline.testingPipelineOptions().as(AutoCompleteITOptions.class);
        options.setInputFile(DEFAULT_INPUT);
        options.setOutputToBigQuery(false);
        options.setOutputToDatastore(false);
        options.setOutputToChecksum(true);
        options.setExpectedChecksum(DEFAULT_INPUT_CHECKSUM);
        AutoComplete.runAutocompletePipeline((AutoComplete.Options)options);
    }

    public static interface AutoCompleteITOptions
    extends TestPipelineOptions,
    AutoComplete.Options {
    }
}

