/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game;

import org.apache.beam.examples.complete.game.StatefulTeamScore;
import org.apache.beam.examples.complete.game.UserScore;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestStream;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StatefulTeamScoreTest {
    private Instant baseTime = new Instant(0L);
    @Rule
    public TestPipeline p = TestPipeline.create();

    @Test
    public void testScoreUpdatesOneTeam() {
        TestStream createEvents = TestStream.create((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)AvroCoder.of(UserScore.GameActionInfo.class))).advanceWatermarkTo(this.baseTime).addElements(this.event(TestUser.RED_TWO, 99, Duration.standardSeconds((long)10L)), new TimestampedValue[]{this.event(TestUser.RED_ONE, 1, Duration.standardSeconds((long)20L)), this.event(TestUser.RED_ONE, 0, Duration.standardSeconds((long)30L)), this.event(TestUser.RED_TWO, 100, Duration.standardSeconds((long)40L)), this.event(TestUser.RED_TWO, 201, Duration.standardSeconds((long)50L))}).advanceWatermarkToInfinity();
        PCollection teamScores = (PCollection)((PCollection)this.p.apply((PTransform)createEvents)).apply((PTransform)ParDo.of((DoFn)new StatefulTeamScore.UpdateTeamScoreFn(100)));
        String redTeam = TestUser.RED_ONE.getTeam();
        PAssert.that((PCollection)teamScores).inWindow((BoundedWindow)GlobalWindow.INSTANCE).containsInAnyOrder((Object[])new KV[]{KV.of((Object)redTeam, (Object)100), KV.of((Object)redTeam, (Object)200), KV.of((Object)redTeam, (Object)401)});
        this.p.run().waitUntilFinish();
    }

    @Test
    public void testScoreUpdatesPerTeam() {
        TestStream createEvents = TestStream.create((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)AvroCoder.of(UserScore.GameActionInfo.class))).advanceWatermarkTo(this.baseTime).addElements(this.event(TestUser.RED_ONE, 50, Duration.standardSeconds((long)10L)), new TimestampedValue[]{this.event(TestUser.RED_TWO, 50, Duration.standardSeconds((long)20L)), this.event(TestUser.BLUE_ONE, 70, Duration.standardSeconds((long)30L)), this.event(TestUser.BLUE_TWO, 80, Duration.standardSeconds((long)40L)), this.event(TestUser.BLUE_TWO, 50, Duration.standardSeconds((long)50L))}).advanceWatermarkToInfinity();
        PCollection teamScores = (PCollection)((PCollection)this.p.apply((PTransform)createEvents)).apply((PTransform)ParDo.of((DoFn)new StatefulTeamScore.UpdateTeamScoreFn(100)));
        String redTeam = TestUser.RED_ONE.getTeam();
        String blueTeam = TestUser.BLUE_ONE.getTeam();
        PAssert.that((PCollection)teamScores).inWindow((BoundedWindow)GlobalWindow.INSTANCE).containsInAnyOrder((Object[])new KV[]{KV.of((Object)redTeam, (Object)100), KV.of((Object)blueTeam, (Object)150), KV.of((Object)blueTeam, (Object)200)});
        this.p.run().waitUntilFinish();
    }

    @Test
    public void testScoreUpdatesPerWindow() {
        TestStream createEvents = TestStream.create((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)AvroCoder.of(UserScore.GameActionInfo.class))).advanceWatermarkTo(this.baseTime).addElements(this.event(TestUser.RED_ONE, 50, Duration.standardMinutes((long)1L)), new TimestampedValue[]{this.event(TestUser.RED_TWO, 50, Duration.standardMinutes((long)2L)), this.event(TestUser.RED_ONE, 50, Duration.standardMinutes((long)3L)), this.event(TestUser.RED_ONE, 60, Duration.standardMinutes((long)6L)), this.event(TestUser.RED_TWO, 60, Duration.standardMinutes((long)7L))}).advanceWatermarkToInfinity();
        Duration teamWindowDuration = Duration.standardMinutes((long)5L);
        PCollection teamScores = (PCollection)((PCollection)((PCollection)this.p.apply((PTransform)createEvents)).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)teamWindowDuration)))).apply((PTransform)ParDo.of((DoFn)new StatefulTeamScore.UpdateTeamScoreFn(100)));
        String redTeam = TestUser.RED_ONE.getTeam();
        IntervalWindow window1 = new IntervalWindow(this.baseTime, (ReadableDuration)teamWindowDuration);
        IntervalWindow window2 = new IntervalWindow(window1.end(), (ReadableDuration)teamWindowDuration);
        PAssert.that((PCollection)teamScores).inWindow((BoundedWindow)window1).containsInAnyOrder((Object[])new KV[]{KV.of((Object)redTeam, (Object)100)});
        PAssert.that((PCollection)teamScores).inWindow((BoundedWindow)window2).containsInAnyOrder((Object[])new KV[]{KV.of((Object)redTeam, (Object)120)});
        this.p.run().waitUntilFinish();
    }

    private TimestampedValue<KV<String, UserScore.GameActionInfo>> event(TestUser user, int score, Duration baseTimeOffset) {
        return TimestampedValue.of((Object)KV.of((Object)user.getTeam(), (Object)new UserScore.GameActionInfo(user.getUser(), user.getTeam(), Integer.valueOf(score), Long.valueOf(this.baseTime.plus((ReadableDuration)baseTimeOffset).getMillis()))), (Instant)this.baseTime.plus((ReadableDuration)baseTimeOffset));
    }

    private static enum TestUser {
        RED_ONE("scarlet", "red"),
        RED_TWO("burgundy", "red"),
        BLUE_ONE("navy", "blue"),
        BLUE_TWO("sky", "blue");

        private final String userName;
        private final String teamName;

        private TestUser(String userName, String teamName) {
            this.userName = userName;
            this.teamName = teamName;
        }

        public String getUser() {
            return this.userName;
        }

        public String getTeam() {
            return this.teamName;
        }
    }
}

