/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.examples.complete.game.UserScore;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UserScoreTest
implements Serializable {
    static final String[] GAME_EVENTS_ARRAY = new String[]{"user0_MagentaKangaroo,MagentaKangaroo,3,1447955630000,2015-11-19 09:53:53.444", "user13_ApricotQuokka,ApricotQuokka,15,1447955630000,2015-11-19 09:53:53.444", "user6_AmberNumbat,AmberNumbat,11,1447955630000,2015-11-19 09:53:53.444", "user7_AlmondWallaby,AlmondWallaby,15,1447955630000,2015-11-19 09:53:53.444", "user7_AndroidGreenKookaburra,AndroidGreenKookaburra,12,1447955630000,2015-11-19 09:53:53.444", "user6_AliceBlueDingo,AliceBlueDingo,4,xxxxxxx,2015-11-19 09:53:53.444", "user7_AndroidGreenKookaburra,AndroidGreenKookaburra,11,1447955630000,2015-11-19 09:53:53.444", "THIS IS A PARSE ERROR,2015-11-19 09:53:53.444", "user19_BisqueBilby,BisqueBilby,6,1447955630000,2015-11-19 09:53:53.444", "user19_BisqueBilby,BisqueBilby,8,1447955630000,2015-11-19 09:53:53.444"};
    static final String[] GAME_EVENTS_ARRAY2 = new String[]{"user6_AliceBlueDingo,AliceBlueDingo,4,xxxxxxx,2015-11-19 09:53:53.444", "THIS IS A PARSE ERROR,2015-11-19 09:53:53.444", "user13_BisqueBilby,BisqueBilby,xxx,1447955630000,2015-11-19 09:53:53.444"};
    static final List<String> GAME_EVENTS = Arrays.asList(GAME_EVENTS_ARRAY);
    static final List<String> GAME_EVENTS2 = Arrays.asList(GAME_EVENTS_ARRAY2);
    static final List<UserScore.GameActionInfo> GAME_ACTION_INFO_LIST = Lists.newArrayList((Object[])new UserScore.GameActionInfo[]{new UserScore.GameActionInfo("user0_MagentaKangaroo", "MagentaKangaroo", Integer.valueOf(3), Long.valueOf(1447955630000L)), new UserScore.GameActionInfo("user13_ApricotQuokka", "ApricotQuokka", Integer.valueOf(15), Long.valueOf(1447955630000L)), new UserScore.GameActionInfo("user6_AmberNumbat", "AmberNumbat", Integer.valueOf(11), Long.valueOf(1447955630000L)), new UserScore.GameActionInfo("user7_AlmondWallaby", "AlmondWallaby", Integer.valueOf(15), Long.valueOf(1447955630000L)), new UserScore.GameActionInfo("user7_AndroidGreenKookaburra", "AndroidGreenKookaburra", Integer.valueOf(12), Long.valueOf(1447955630000L)), new UserScore.GameActionInfo("user7_AndroidGreenKookaburra", "AndroidGreenKookaburra", Integer.valueOf(11), Long.valueOf(1447955630000L)), new UserScore.GameActionInfo("user19_BisqueBilby", "BisqueBilby", Integer.valueOf(6), Long.valueOf(1447955630000L)), new UserScore.GameActionInfo("user19_BisqueBilby", "BisqueBilby", Integer.valueOf(8), Long.valueOf(1447955630000L))});
    static final List<KV<String, Integer>> USER_SUMS = Arrays.asList(KV.of((Object)"user0_MagentaKangaroo", (Object)3), KV.of((Object)"user13_ApricotQuokka", (Object)15), KV.of((Object)"user6_AmberNumbat", (Object)11), KV.of((Object)"user7_AlmondWallaby", (Object)15), KV.of((Object)"user7_AndroidGreenKookaburra", (Object)23), KV.of((Object)"user19_BisqueBilby", (Object)14));
    static final List<KV<String, Integer>> TEAM_SUMS = Arrays.asList(KV.of((Object)"MagentaKangaroo", (Object)3), KV.of((Object)"ApricotQuokka", (Object)15), KV.of((Object)"AmberNumbat", (Object)11), KV.of((Object)"AlmondWallaby", (Object)15), KV.of((Object)"AndroidGreenKookaburra", (Object)23), KV.of((Object)"BisqueBilby", (Object)14));
    @Rule
    public TestPipeline p = TestPipeline.create();

    @Test
    public void testParseEventFn() throws Exception {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(GAME_EVENTS));
        PCollection output = (PCollection)input.apply((PTransform)ParDo.of((DoFn)new UserScore.ParseEventFn()));
        PAssert.that((PCollection)output).containsInAnyOrder(GAME_ACTION_INFO_LIST);
        this.p.run().waitUntilFinish();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testUserScoreSums() throws Exception {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(GAME_EVENTS));
        PCollection output = (PCollection)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new UserScore.ParseEventFn()))).apply("ExtractUserScore", (PTransform)new UserScore.ExtractAndSumScore("user"));
        PAssert.that((PCollection)output).containsInAnyOrder(USER_SUMS);
        this.p.run().waitUntilFinish();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testTeamScoreSums() throws Exception {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(GAME_EVENTS));
        PCollection output = (PCollection)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new UserScore.ParseEventFn()))).apply("ExtractTeamScore", (PTransform)new UserScore.ExtractAndSumScore("team"));
        PAssert.that((PCollection)output).containsInAnyOrder(TEAM_SUMS);
        this.p.run().waitUntilFinish();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testUserScoresBadInput() throws Exception {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of(GAME_EVENTS2).withCoder((Coder)StringUtf8Coder.of()));
        PCollection extract = (PCollection)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new UserScore.ParseEventFn()))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.strings(), (TypeDescriptor)TypeDescriptors.integers())).via((SerializableFunction & Serializable)gInfo -> KV.of((Object)gInfo.getUser(), (Object)gInfo.getScore())));
        PAssert.that((PCollection)extract).empty();
        this.p.run().waitUntilFinish();
    }
}

