/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.examples.WordCount;
import org.apache.beam.examples.common.ExampleBigQueryTableOptions;
import org.apache.beam.examples.common.ExampleOptions;
import org.apache.beam.examples.common.WriteOneFilePerWindow;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class WindowedWordCount {
    static final @UnknownKeyFor @NonNull @Initialized int WINDOW_SIZE = 10;

    static void runWindowedWordCount(@UnknownKeyFor @NonNull @Initialized Options options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String output = options.getOutput();
        Instant minTimestamp = new Instant((Object)options.getMinTimestampMillis());
        Instant maxTimestamp = new Instant((Object)options.getMaxTimestampMillis());
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        PCollection input = (PCollection)((PCollection)pipeline.apply((PTransform)TextIO.read().from(options.getInputFile()))).apply((PTransform)ParDo.of((DoFn)new AddTimestampFn(minTimestamp, maxTimestamp)));
        PCollection windowedWords = (PCollection)input.apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)options.getWindowSize().intValue()))));
        PCollection wordCounts = (PCollection)windowedWords.apply((PTransform)new WordCount.CountWords());
        ((PCollection)wordCounts.apply((PTransform)MapElements.via((SimpleFunction)new WordCount.FormatAsTextFn()))).apply((PTransform)new WriteOneFilePerWindow(output, options.getNumShards()));
        PipelineResult result = pipeline.run();
        try {
            result.waitUntilFinish();
        }
        catch (Exception exc) {
            result.cancel();
        }
    }

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Options options = (Options)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(Options.class);
        WindowedWordCount.runWindowedWordCount(options);
    }

    public static interface Options
    extends WordCount.WordCountOptions,
    ExampleOptions,
    ExampleBigQueryTableOptions {
        @Description(value="Fixed window duration, in minutes")
        @Default.Integer(value=10)
        public @UnknownKeyFor @NonNull @Initialized Integer getWindowSize();

        public void setWindowSize(@UnknownKeyFor @NonNull @Initialized Integer var1);

        @Description(value="Minimum randomly assigned timestamp, in milliseconds-since-epoch")
        @Default.InstanceFactory(value=DefaultToCurrentSystemTime.class)
        public @UnknownKeyFor @NonNull @Initialized Long getMinTimestampMillis();

        public void setMinTimestampMillis(@UnknownKeyFor @NonNull @Initialized Long var1);

        @Description(value="Maximum randomly assigned timestamp, in milliseconds-since-epoch")
        @Default.InstanceFactory(value=DefaultToMinTimestampPlusOneHour.class)
        public @UnknownKeyFor @NonNull @Initialized Long getMaxTimestampMillis();

        public void setMaxTimestampMillis(@UnknownKeyFor @NonNull @Initialized Long var1);

        @Description(value="Fixed number of shards to produce per window")
        public @UnknownKeyFor @NonNull @Initialized Integer getNumShards();

        public void setNumShards(@UnknownKeyFor @NonNull @Initialized Integer var1);
    }

    public static class DefaultToMinTimestampPlusOneHour
    implements DefaultValueFactory<Long> {
        public @UnknownKeyFor @NonNull @Initialized Long create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return ((Options)options.as(Options.class)).getMinTimestampMillis() + Duration.standardHours((long)1L).getMillis();
        }
    }

    public static class DefaultToCurrentSystemTime
    implements DefaultValueFactory<Long> {
        public @UnknownKeyFor @NonNull @Initialized Long create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return System.currentTimeMillis();
        }
    }

    static class AddTimestampFn
    extends DoFn<String, String> {
        private final @UnknownKeyFor @NonNull @Initialized Instant minTimestamp;
        private final @UnknownKeyFor @NonNull @Initialized Instant maxTimestamp;

        AddTimestampFn(@UnknownKeyFor @NonNull @Initialized Instant minTimestamp, @UnknownKeyFor @NonNull @Initialized Instant maxTimestamp) {
            this.minTimestamp = minTimestamp;
            this.maxTimestamp = maxTimestamp;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String element, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized String> receiver) {
            Instant randomTimestamp = new Instant(ThreadLocalRandom.current().nextLong(this.minTimestamp.getMillis(), this.maxTimestamp.getMillis()));
            receiver.outputWithTimestamp((Object)element, randomTimestamp);
        }
    }
}

