/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import com.google.api.services.bigquery.model.TableRow;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimalBigQueryTornadoes {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MinimalBigQueryTornadoes.class);
    private static final @UnknownKeyFor @NonNull @Initialized String WEATHER_SAMPLES_TABLE = "clouddataflow-readonly:samples.weather_stations";

    public static void applyBigQueryTornadoes(@UnknownKeyFor @NonNull @Initialized Pipeline p) {
        BigQueryIO.TypedRead bigqueryIO = BigQueryIO.readTableRows().from(WEATHER_SAMPLES_TABLE).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).withSelectedFields((List)Lists.newArrayList((Object[])new String[]{"month", "tornado"}));
        PCollection rowsFromBigQuery = (PCollection)p.apply((PTransform)bigqueryIO);
        ((PCollection)((PCollection)((PCollection)((PCollection)rowsFromBigQuery.apply((PTransform)ParDo.of((DoFn)new ExtractTornadoesFn()))).apply(Count.perElement())).apply((PTransform)ParDo.of((DoFn)new FormatCountsFn()))).apply((PTransform)ParDo.of(new LogOutput("Result: ")))).apply((PTransform)TextIO.write().to("tornadoes"));
    }

    public static void runBigQueryTornadoes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        Pipeline p = Pipeline.create((PipelineOptions)options);
        MinimalBigQueryTornadoes.applyBigQueryTornadoes(p);
        p.run().waitUntilFinish();
    }

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(PipelineOptions.class);
        MinimalBigQueryTornadoes.runBigQueryTornadoes(options);
    }

    static class LogOutput<@UnknownKeyFor T>
    extends DoFn<T, T> {
        private final @UnknownKeyFor @NonNull @Initialized String prefix;

        LogOutput(@UnknownKeyFor @NonNull @Initialized String prefix) {
            this.prefix = prefix;
        }

        @DoFn.ProcessElement
        public void processElement(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            LOG.info(this.prefix + c.element());
            c.output(c.element());
        }
    }

    static class FormatCountsFn
    extends DoFn<KV<Integer, Long>, String> {
        FormatCountsFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            c.output((Object)(((KV)c.element()).getKey() + ": " + ((KV)c.element()).getValue()));
        }
    }

    static class ExtractTornadoesFn
    extends DoFn<TableRow, Integer> {
        ExtractTornadoesFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            TableRow row = (TableRow)c.element();
            if (((Boolean)row.get((Object)"tornado")).booleanValue()) {
                c.output((Object)Integer.parseInt((String)row.get((Object)"month")));
            }
        }
    }
}

