/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.snippets.transforms.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class BigQueryWriteToTable {
    BigQueryWriteToTable() {
    }

    public static void writeToTable(@UnknownKeyFor @NonNull @Initialized String project, @UnknownKeyFor @NonNull @Initialized String dataset, @UnknownKeyFor @NonNull @Initialized String table, @UnknownKeyFor @NonNull @Initialized TableSchema schema, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> rows) {
        rows.apply("Write to BigQuery", (PTransform)BigQueryIO.writeTableRows().to(String.format("%s:%s.%s", project, dataset, table)).withSchema(schema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
    }
}

