/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.subprocess;

import org.apache.beam.examples.subprocess.configuration.SubProcessConfiguration;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.Validation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface SubProcessPipelineOptions
extends PipelineOptions {
    @Description(value="Source GCS directory where the C++ library is located gs://bucket/tests")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized String getSourcePath();

    public void setSourcePath(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Working directory for the process I/O")
    @Default.String(value="/tmp/grid_working_files")
    public @UnknownKeyFor @NonNull @Initialized String getWorkerPath();

    public void setWorkerPath(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The maximum time to wait for the sub-process to complete")
    @Default.Integer(value=3600)
    public @UnknownKeyFor @NonNull @Initialized Integer getWaitTime();

    public void setWaitTime(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="As sub-processes can be heavy weight define the level of concurrency level")
    @Validation.Required
    public @UnknownKeyFor @NonNull @Initialized Integer getConcurrency();

    public void setConcurrency(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="Should log files only be uploaded if error.")
    @Default.Boolean(value=true)
    public @UnknownKeyFor @NonNull @Initialized Boolean getOnlyUpLoadLogsOnError();

    public void setOnlyUpLoadLogsOnError(@UnknownKeyFor @NonNull @Initialized Boolean var1);

    @Default.InstanceFactory(value=SubProcessConfigurationFactory.class)
    public @UnknownKeyFor @NonNull @Initialized SubProcessConfiguration getSubProcessConfiguration();

    public void setSubProcessConfiguration(@UnknownKeyFor @NonNull @Initialized SubProcessConfiguration var1);

    public static class SubProcessConfigurationFactory
    implements DefaultValueFactory<SubProcessConfiguration> {
        public @UnknownKeyFor @NonNull @Initialized SubProcessConfiguration create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            SubProcessPipelineOptions subProcessPipelineOptions = (SubProcessPipelineOptions)options;
            SubProcessConfiguration configuration = new SubProcessConfiguration();
            if (subProcessPipelineOptions.getSourcePath() == null) {
                throw new IllegalStateException("Source path must be set");
            }
            if (subProcessPipelineOptions.getConcurrency() == null || subProcessPipelineOptions.getConcurrency() == 0) {
                throw new IllegalStateException("Concurrency must be set and be > 0");
            }
            configuration.setSourcePath(subProcessPipelineOptions.getSourcePath());
            configuration.setWorkerPath(subProcessPipelineOptions.getWorkerPath());
            configuration.setWaitTime(subProcessPipelineOptions.getWaitTime());
            configuration.setOnlyUpLoadLogsOnError(subProcessPipelineOptions.getOnlyUpLoadLogsOnError());
            configuration.concurrency = subProcessPipelineOptions.getConcurrency();
            return configuration;
        }
    }
}

