/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.subprocess.utils;

import org.apache.beam.examples.subprocess.configuration.SubProcessConfiguration;
import org.apache.beam.examples.subprocess.utils.FileUtils;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@DefaultCoder(value=AvroCoder.class)
public class ExecutableFile {
    @UnknownKeyFor @NonNull @Initialized String fileName;
    private @UnknownKeyFor @NonNull @Initialized String sourceGCSLocation;
    private @UnknownKeyFor @NonNull @Initialized String destinationLocation;

    public @UnknownKeyFor @NonNull @Initialized String getSourceGCSLocation() {
        return this.sourceGCSLocation;
    }

    public void setSourceGCSLocation(@UnknownKeyFor @NonNull @Initialized String sourceGCSLocation) {
        this.sourceGCSLocation = sourceGCSLocation;
    }

    public @UnknownKeyFor @NonNull @Initialized String getDestinationLocation() {
        return this.destinationLocation;
    }

    public void setDestinationLocation(@UnknownKeyFor @NonNull @Initialized String destinationLocation) {
        this.destinationLocation = destinationLocation;
    }

    public ExecutableFile(@UnknownKeyFor @NonNull @Initialized SubProcessConfiguration configuration, @UnknownKeyFor @NonNull @Initialized String fileName) throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
        if (configuration == null) {
            throw new IllegalStateException("Configuration can not be NULL");
        }
        if (fileName == null) {
            throw new IllegalStateException("FileName can not be NULLt");
        }
        this.fileName = fileName;
        this.setDestinationLocation(configuration);
        this.setSourceLocation(configuration);
    }

    private void setDestinationLocation(@UnknownKeyFor @NonNull @Initialized SubProcessConfiguration configuration) {
        this.sourceGCSLocation = FileUtils.getFileResourceId(configuration.getSourcePath(), this.fileName).toString();
    }

    private void setSourceLocation(@UnknownKeyFor @NonNull @Initialized SubProcessConfiguration configuration) {
        this.destinationLocation = FileUtils.getFileResourceId(configuration.getWorkerPath(), this.fileName).toString();
    }
}

