/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete;

import java.util.Date;
import org.apache.beam.examples.complete.TopWikipediaSessions;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.FileChecksumMatcher;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.util.NumberedShardedFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TopWikipediaSessionsIT {
    private static final String DEFAULT_INPUT_10_FILES = "gs://apache-beam-samples/wikipedia_edits/wiki_data-000000000000.json";
    private static final String DEFAULT_OUTPUT_CHECKSUM = "13347784d49129bade295c371e30f9eb5325318a";

    @BeforeClass
    public static void setUp() {
        PipelineOptionsFactory.register(TestPipelineOptions.class);
    }

    @Test
    public void testE2ETopWikiPages() throws Exception {
        TopWikipediaSessionsITOptions options = (TopWikipediaSessionsITOptions)TestPipeline.testingPipelineOptions().as(TopWikipediaSessionsITOptions.class);
        options.setWikiInput(DEFAULT_INPUT_10_FILES);
        options.setOutput(FileSystems.matchNewResource((String)options.getTempRoot(), (boolean)true).resolve(String.format("topwikisessions-it-%tF-%<tH-%<tM-%<tS-%<tL", new Date()), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("output", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("results", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString());
        TopWikipediaSessions.run((TopWikipediaSessions.Options)options);
        MatcherAssert.assertThat((Object)new NumberedShardedFile(options.getOutput() + "*-of-*"), (Matcher)FileChecksumMatcher.fileContentsHaveChecksum((String)DEFAULT_OUTPUT_CHECKSUM));
    }

    public static interface TopWikipediaSessionsITOptions
    extends TestPipelineOptions,
    TopWikipediaSessions.Options {
    }
}

