/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.kafkatopubsub;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.examples.complete.kafkatopubsub.kafka.consumer.Utils;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KafkaToPubsubTest {
    @Test
    public void testConfigureKafkaNullProps() {
        Map config = Utils.configureKafka(null);
        Assert.assertEquals(new HashMap(), (Object)config);
    }

    @Test
    public void testConfigureKafkaNoPassword() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("username", "username");
        Map config = Utils.configureKafka(props);
        Assert.assertEquals(new HashMap(), (Object)config);
    }

    @Test
    public void testConfigureKafkaNoUsername() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("password", "password");
        Map config = Utils.configureKafka(props);
        Assert.assertEquals(new HashMap(), (Object)config);
    }

    @Test
    public void testConfigureKafka() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("username", "username");
        props.put("password", "password");
        HashMap<String, String> expectedConfig = new HashMap<String, String>();
        expectedConfig.put("sasl.mechanism", ScramMechanism.SCRAM_SHA_512.mechanismName());
        expectedConfig.put("sasl.jaas.config", String.format("org.apache.kafka.common.security.scram.ScramLoginModule required username=\"%s\" password=\"%s\";", props.get("username"), props.get("password")));
        Map config = Utils.configureKafka(props);
        Assert.assertEquals(expectedConfig, (Object)config);
    }

    @Test
    public void testGetKafkaCredentialsFromVaultInvalidUrl() {
        Map credentials = Utils.getKafkaCredentialsFromVault((String)"some-url", (String)"some-token");
        Assert.assertEquals(new HashMap(), (Object)credentials);
    }
}

