/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import java.util.Date;
import java.util.regex.Pattern;
import org.apache.beam.examples.cookbook.DistinctExample;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.FileChecksumMatcher;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.util.NumberedShardedFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DistinctExampleIT {
    private static final String EXPECTED_OUTPUT_CHECKSUM = "474c8925d94dce3b8147e6ec88c551c9066effd0";
    private static final Pattern DEFAULT_SHARD_TEMPLATE = Pattern.compile("(?x) \\S* (?<shardnum> \\d+) -of- (?<numshards> \\d+)");

    @BeforeClass
    public static void setUp() {
        PipelineOptionsFactory.register(TestPipelineOptions.class);
    }

    @Test
    public void testE2EDistinctExample() throws Exception {
        DistinctExampleOptions options = (DistinctExampleOptions)TestPipeline.testingPipelineOptions().as(DistinctExampleOptions.class);
        options.setOutput(FileSystems.matchNewResource((String)options.getTempRoot(), (boolean)true).resolve(String.format("DistinctExample-%tF-%<tH-%<tM-%<tS-%<tL", new Date()), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("output", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("results", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString());
        DistinctExample.runDistinctExample((DistinctExample.Options)options);
        MatcherAssert.assertThat((Object)new NumberedShardedFile(options.getOutput() + "*-of-*", DEFAULT_SHARD_TEMPLATE), (Matcher)FileChecksumMatcher.fileContentsHaveChecksum((String)EXPECTED_OUTPUT_CHECKSUM));
    }

    public static interface DistinctExampleOptions
    extends TestPipelineOptions,
    DistinctExample.Options {
    }
}

