/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.cookbook;

import java.util.Date;
import java.util.regex.Pattern;
import org.apache.beam.examples.cookbook.JoinExamples;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.FileChecksumMatcher;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.util.NumberedShardedFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JoinExamplesIT {
    private static final String EXPECTED_OUTPUT_CHECKSUM = "22394366a77255b6941ec747794df4f51f73c07d";
    private static final Pattern DEFAULT_SHARD_TEMPLATE = Pattern.compile("(?x) \\S* (?<shardnum> \\d+) -of- (?<numshards> \\d+)");

    @BeforeClass
    public static void setUp() {
        PipelineOptionsFactory.register(TestPipelineOptions.class);
    }

    @Test
    public void testE2EJoinExamples() throws Exception {
        JoinExamplesOptions options = (JoinExamplesOptions)TestPipeline.testingPipelineOptions().as(JoinExamplesOptions.class);
        options.setOutput(FileSystems.matchNewResource((String)options.getTempRoot(), (boolean)true).resolve(String.format("JoinExamples-%tF-%<tH-%<tM-%<tS-%<tL", new Date()), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("output", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("results", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString());
        JoinExamples.runJoinExamples((JoinExamples.Options)options);
        MatcherAssert.assertThat((Object)new NumberedShardedFile(options.getOutput() + "*-of-*", DEFAULT_SHARD_TEMPLATE), (Matcher)FileChecksumMatcher.fileContentsHaveChecksum((String)EXPECTED_OUTPUT_CHECKSUM));
    }

    public static interface JoinExamplesOptions
    extends TestPipelineOptions,
    JoinExamples.Options {
    }
}

