/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.snippets;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.examples.snippets.Snippets;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.UsesStatefulParDo;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SnippetsTest
implements Serializable {
    @Rule
    public final transient TestPipeline p = TestPipeline.create();

    @Test
    public void testModelBigQueryIO() {
        boolean runLocally = false;
        if (runLocally) {
            String project = "my-project";
            String dataset = "samples";
            String table = "modelBigQueryIO";
            BigQueryOptions options = (BigQueryOptions)PipelineOptionsFactory.create().as(BigQueryOptions.class);
            options.setProject(project);
            options.setTempLocation("gs://" + project + "/samples/temp/");
            Pipeline p = Pipeline.create((PipelineOptions)options);
            Snippets.modelBigQueryIO((Pipeline)p, (String)project, (String)dataset, (String)table);
            p.run();
        } else {
            Pipeline p = Pipeline.create();
            Snippets.modelBigQueryIO((Pipeline)p);
        }
    }

    @Test
    public void testCoGroupByKeyTuple() throws IOException {
        List<KV> emailsList = Arrays.asList(KV.of((Object)"amy", (Object)"amy@example.com"), KV.of((Object)"carl", (Object)"carl@example.com"), KV.of((Object)"julia", (Object)"julia@example.com"), KV.of((Object)"carl", (Object)"carl@email.com"));
        List<KV> phonesList = Arrays.asList(KV.of((Object)"amy", (Object)"111-222-3333"), KV.of((Object)"james", (Object)"222-333-4444"), KV.of((Object)"amy", (Object)"333-444-5555"), KV.of((Object)"carl", (Object)"444-555-6666"));
        PCollection emails = (PCollection)this.p.apply("CreateEmails", (PTransform)Create.of(emailsList));
        PCollection phones = (PCollection)this.p.apply("CreatePhones", (PTransform)Create.of(phonesList));
        TupleTag emailsTag = new TupleTag();
        TupleTag phonesTag = new TupleTag();
        List<KV> expectedResults = Arrays.asList(KV.of((Object)"amy", (Object)CoGbkResult.of((TupleTag)emailsTag, Arrays.asList("amy@example.com")).and(phonesTag, Arrays.asList("111-222-3333", "333-444-5555"))), KV.of((Object)"carl", (Object)CoGbkResult.of((TupleTag)emailsTag, Arrays.asList("carl@email.com", "carl@example.com")).and(phonesTag, Arrays.asList("444-555-6666"))), KV.of((Object)"james", (Object)CoGbkResult.of((TupleTag)emailsTag, Arrays.asList(new String[0])).and(phonesTag, Arrays.asList("222-333-4444"))), KV.of((Object)"julia", (Object)CoGbkResult.of((TupleTag)emailsTag, Arrays.asList("julia@example.com")).and(phonesTag, Arrays.asList(new String[0]))));
        PCollection actualFormattedResults = Snippets.coGroupByKeyTuple((TupleTag)emailsTag, (TupleTag)phonesTag, (PCollection)emails, (PCollection)phones);
        List<String> formattedResults = Arrays.asList("amy; ['amy@example.com']; ['111-222-3333', '333-444-5555']", "carl; ['carl@email.com', 'carl@example.com']; ['444-555-6666']", "james; []; ['222-333-4444']", "julia; ['julia@example.com']; []");
        ArrayList<String> expectedFormattedResultsList = new ArrayList<String>(expectedResults.size());
        for (KV e : expectedResults) {
            String name = (String)e.getKey();
            Iterable emailsIter = ((CoGbkResult)e.getValue()).getAll(emailsTag);
            Iterable phonesIter = ((CoGbkResult)e.getValue()).getAll(phonesTag);
            String formattedResult = Snippets.formatCoGbkResults((String)name, (Iterable)emailsIter, (Iterable)phonesIter);
            expectedFormattedResultsList.add(formattedResult);
        }
        PCollection expectedFormattedResultsPColl = (PCollection)this.p.apply((PTransform)Create.of(expectedFormattedResultsList));
        PAssert.that((PCollection)expectedFormattedResultsPColl).containsInAnyOrder(formattedResults);
        PAssert.that((PCollection)actualFormattedResults).containsInAnyOrder(formattedResults);
        this.p.run();
    }

    @Test
    public void testSchemaJoinPattern() {
        Schema emailSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"email", (Schema.FieldType)Schema.FieldType.STRING)});
        Schema phoneSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"phone", (Schema.FieldType)Schema.FieldType.STRING)});
        List<Row> emailUsers = Arrays.asList(Row.withSchema((Schema)emailSchema).addValue((Object)"person1").addValue((Object)"person1@example.com").build(), Row.withSchema((Schema)emailSchema).addValue((Object)"person2").addValue((Object)"person2@example.com").build(), Row.withSchema((Schema)emailSchema).addValue((Object)"person3").addValue((Object)"person3@example.com").build(), Row.withSchema((Schema)emailSchema).addValue((Object)"person4").addValue((Object)"person4@example.com").build(), Row.withSchema((Schema)emailSchema).addValue((Object)"person6").addValue((Object)"person6@example.com").build());
        List<Row> phoneUsers = Arrays.asList(Row.withSchema((Schema)phoneSchema).addValue((Object)"person1").addValue((Object)"111-222-3333").build(), Row.withSchema((Schema)phoneSchema).addValue((Object)"person2").addValue((Object)"222-333-4444").build(), Row.withSchema((Schema)phoneSchema).addValue((Object)"person3").addValue((Object)"444-333-4444").build(), Row.withSchema((Schema)phoneSchema).addValue((Object)"person4").addValue((Object)"555-333-4444").build(), Row.withSchema((Schema)phoneSchema).addValue((Object)"person5").addValue((Object)"777-333-4444").build());
        PCollection actualFormattedResult = Snippets.SchemaJoinPattern.main((Pipeline)this.p, emailUsers, phoneUsers, (Schema)emailSchema, (Schema)phoneSchema);
        List<String> formattedResults = Arrays.asList("Name: person1 Email: person1@example.com Phone: 111-222-3333", "Name: person2 Email: person2@example.com Phone: 222-333-4444", "Name: person3 Email: person3@example.com Phone: 444-333-4444", "Name: person4 Email: person4@example.com Phone: 555-333-4444");
        ArrayList<String> expectedFormattedResultsList = new ArrayList<String>(formattedResults.size());
        for (int i = 0; i < formattedResults.size(); ++i) {
            String userInfo = "Name: " + emailUsers.get(i).getValue("name") + " Email: " + emailUsers.get(i).getValue("email") + " Phone: " + phoneUsers.get(i).getValue("phone");
            expectedFormattedResultsList.add(userInfo);
        }
        PCollection expectedFormattedResultPcoll = (PCollection)this.p.apply((PTransform)Create.of(expectedFormattedResultsList));
        PAssert.that((PCollection)expectedFormattedResultPcoll).containsInAnyOrder(formattedResults);
        PAssert.that((PCollection)actualFormattedResult).containsInAnyOrder(formattedResults);
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class, UsesStatefulParDo.class})
    public void testSlowlyUpdatingSideInputsWindowed() {
        Instant startAt = Instant.now().minus((ReadableDuration)Duration.standardMinutes((long)3L));
        Duration duration = Duration.standardSeconds((long)10L);
        Instant stopAt = startAt.plus((ReadableDuration)duration);
        Duration interval1 = Duration.standardSeconds((long)1L);
        Duration interval2 = Duration.standardSeconds((long)1L);
        File f = null;
        try {
            f = File.createTempFile("testSlowlyUpdatingSIWindowed", "txt");
            try (BufferedWriter fw = Files.newWriter((File)f, (Charset)Charset.forName("UTF-8"));){
                fw.append("testdata");
            }
        }
        catch (IOException e) {
            Assert.fail((String)("failed to create temp file: " + e.toString()));
            throw new RuntimeException("Should never reach here");
        }
        PCollection result = Snippets.PeriodicallyUpdatingSideInputs.main((Pipeline)this.p, (Instant)startAt, (Instant)stopAt, (Duration)interval1, (Duration)interval2, (String)f.getPath());
        ArrayList<Long> expectedResults = new ArrayList<Long>();
        expectedResults.add(0L);
        Long i = startAt.getMillis();
        while (i < stopAt.getMillis()) {
            expectedResults.add(1L);
            i = i + interval2.getMillis();
        }
        PAssert.that((PCollection)result).containsInAnyOrder(expectedResults);
        this.p.run().waitUntilFinish();
        f.deleteOnExit();
    }
}

