/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.reflect.Nullable;
import org.apache.beam.examples.common.ExampleBigQueryTableOptions;
import org.apache.beam.examples.common.ExampleOptions;
import org.apache.beam.examples.common.ExampleUtils;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TrafficRoutes {
    static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> sdStations = TrafficRoutes.buildStationInfo();
    static final @UnknownKeyFor @NonNull @Initialized int WINDOW_DURATION = 3;
    static final @UnknownKeyFor @NonNull @Initialized int WINDOW_SLIDE_EVERY = 1;

    public static void runTrafficRoutes(@UnknownKeyFor @NonNull @Initialized TrafficRoutesOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ExampleUtils exampleUtils = new ExampleUtils(options);
        exampleUtils.setup();
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        TableReference tableRef = new TableReference();
        tableRef.setProjectId(options.getProject());
        tableRef.setDatasetId(options.getBigQueryDataset());
        tableRef.setTableId(options.getBigQueryTable());
        ((PCollection)((PCollection)((PCollection)((PCollection)pipeline.apply("ReadLines", (PTransform)new ReadFileAndExtractTimestamps(options.getInputFile()))).apply((PTransform)ParDo.of((DoFn)new ExtractStationSpeedFn()))).apply((PTransform)Window.into((WindowFn)SlidingWindows.of((Duration)Duration.standardMinutes((long)options.getWindowDuration().intValue())).every(Duration.standardMinutes((long)options.getWindowSlideEvery().intValue()))))).apply((PTransform)new TrackSpeed())).apply((PTransform)BigQueryIO.writeTableRows().to(tableRef).withSchema(FormatStatsFn.getSchema()));
        PipelineResult result = pipeline.run();
        exampleUtils.waitToFinish(result);
    }

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized IOException {
        TrafficRoutesOptions options = (TrafficRoutesOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(TrafficRoutesOptions.class);
        TrafficRoutes.runTrafficRoutes(options);
    }

    private static @UnknownKeyFor @NonNull @Initialized Double tryParseAvgSpeed(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] inputItems) {
        try {
            return Double.parseDouble(TrafficRoutes.tryParseString(inputItems, 9));
        }
        catch (NullPointerException | NumberFormatException e) {
            return null;
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String tryParseStationType(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] inputItems) {
        return TrafficRoutes.tryParseString(inputItems, 4);
    }

    private static @UnknownKeyFor @NonNull @Initialized String tryParseStationId(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] inputItems) {
        return TrafficRoutes.tryParseString(inputItems, 1);
    }

    private static @UnknownKeyFor @NonNull @Initialized String tryParseTimestamp(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] inputItems) {
        return TrafficRoutes.tryParseString(inputItems, 0);
    }

    private static @UnknownKeyFor @NonNull @Initialized String tryParseString(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] inputItems, @UnknownKeyFor @NonNull @Initialized int index) {
        return inputItems.length > index ? inputItems[index] : null;
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> buildStationInfo() {
        LinkedHashMap<String, String> stations = new LinkedHashMap<String, String>();
        stations.put("1108413", "SDRoute1");
        stations.put("1108699", "SDRoute2");
        stations.put("1108702", "SDRoute2");
        return stations;
    }

    public static interface TrafficRoutesOptions
    extends ExampleOptions,
    ExampleBigQueryTableOptions {
        @Description(value="Path of the file to read from")
        @Default.String(value="gs://apache-beam-samples/traffic_sensor/Freeways-5Minaa2010-01-01_to_2010-02-15_test2.csv")
        public @UnknownKeyFor @NonNull @Initialized String getInputFile();

        public void setInputFile(@UnknownKeyFor @NonNull @Initialized String var1);

        @Description(value="Numeric value of sliding window duration, in minutes")
        @Default.Integer(value=3)
        public @UnknownKeyFor @NonNull @Initialized Integer getWindowDuration();

        public void setWindowDuration(@UnknownKeyFor @NonNull @Initialized Integer var1);

        @Description(value="Numeric value of window 'slide every' setting, in minutes")
        @Default.Integer(value=1)
        public @UnknownKeyFor @NonNull @Initialized Integer getWindowSlideEvery();

        public void setWindowSlideEvery(@UnknownKeyFor @NonNull @Initialized Integer var1);
    }

    static class ReadFileAndExtractTimestamps
    extends PTransform<PBegin, PCollection<String>> {
        private final @UnknownKeyFor @NonNull @Initialized String inputFile;

        public ReadFileAndExtractTimestamps(@UnknownKeyFor @NonNull @Initialized String inputFile) {
            this.inputFile = inputFile;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> expand(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
            return (PCollection)((PCollection)begin.apply((PTransform)TextIO.read().from(this.inputFile))).apply((PTransform)ParDo.of((DoFn)new ExtractTimestamps()));
        }
    }

    static class TrackSpeed
    extends PTransform<PCollection<KV<String, StationSpeed>>, PCollection<TableRow>> {
        TrackSpeed() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized StationSpeed>> stationSpeed) {
            PCollection timeGroup = (PCollection)stationSpeed.apply((PTransform)GroupByKey.create());
            PCollection stats = (PCollection)timeGroup.apply((PTransform)ParDo.of((DoFn)new GatherStats()));
            PCollection results = (PCollection)stats.apply((PTransform)ParDo.of((DoFn)new FormatStatsFn()));
            return results;
        }
    }

    static class FormatStatsFn
    extends DoFn<KV<String, RouteInfo>, TableRow> {
        FormatStatsFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            RouteInfo routeInfo = (RouteInfo)((KV)c.element()).getValue();
            TableRow row = new TableRow().set("avg_speed", (Object)routeInfo.getAvgSpeed()).set("slowdown_event", (Object)routeInfo.getSlowdownEvent()).set("route", ((KV)c.element()).getKey()).set("window_timestamp", (Object)c.timestamp().toString());
            c.output((Object)row);
        }

        static @UnknownKeyFor @NonNull @Initialized TableSchema getSchema() {
            ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>();
            fields.add(new TableFieldSchema().setName("route").setType("STRING"));
            fields.add(new TableFieldSchema().setName("avg_speed").setType("FLOAT"));
            fields.add(new TableFieldSchema().setName("slowdown_event").setType("BOOLEAN"));
            fields.add(new TableFieldSchema().setName("window_timestamp").setType("TIMESTAMP"));
            return new TableSchema().setFields(fields);
        }
    }

    static class GatherStats
    extends DoFn<KV<String, Iterable<StationSpeed>>, KV<String, RouteInfo>> {
        GatherStats() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String route = (String)((KV)c.element()).getKey();
            double speedSum = 0.0;
            int speedCount = 0;
            int speedups = 0;
            int slowdowns = 0;
            ArrayList infoList = Lists.newArrayList((Iterable)((Iterable)((KV)c.element()).getValue()));
            Collections.sort(infoList);
            HashMap<String, Double> prevSpeeds = new HashMap<String, Double>();
            for (StationSpeed item : infoList) {
                Double speed = item.getAvgSpeed();
                if (speed == null) continue;
                speedSum += speed.doubleValue();
                ++speedCount;
                Double lastSpeed = (Double)prevSpeeds.get(item.getStationId());
                if (lastSpeed != null) {
                    if (lastSpeed < speed) {
                        ++speedups;
                    } else {
                        ++slowdowns;
                    }
                }
                prevSpeeds.put(item.getStationId(), speed);
            }
            if (speedCount == 0) {
                return;
            }
            double speedAvg = speedSum / (double)speedCount;
            boolean slowdownEvent = slowdowns >= 2 * speedups;
            RouteInfo routeInfo = new RouteInfo(route, speedAvg, slowdownEvent);
            c.output((Object)KV.of((Object)route, (Object)routeInfo));
        }
    }

    static class ExtractStationSpeedFn
    extends DoFn<String, KV<String, StationSpeed>> {
        ExtractStationSpeedFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            String[] items = ((String)c.element()).split(",");
            String stationType = TrafficRoutes.tryParseStationType(items);
            if ("ML".equals(stationType)) {
                Double avgSpeed = TrafficRoutes.tryParseAvgSpeed(items);
                String stationId = TrafficRoutes.tryParseStationId(items);
                if (avgSpeed != null && stationId != null && sdStations.containsKey(stationId)) {
                    StationSpeed stationSpeed = new StationSpeed(stationId, avgSpeed, c.timestamp().getMillis());
                    KV outputValue = KV.of((Object)sdStations.get(stationId), (Object)stationSpeed);
                    c.output((Object)outputValue);
                }
            }
        }
    }

    static class ExtractTimestamps
    extends DoFn<String, String> {
        private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter dateTimeFormat = DateTimeFormat.forPattern((String)"MM/dd/yyyy HH:mm:ss");

        ExtractTimestamps() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            String[] items = ((String)c.element()).split(",");
            String timestamp = TrafficRoutes.tryParseTimestamp(items);
            if (timestamp != null) {
                try {
                    c.outputWithTimestamp((Object)((String)c.element()), new Instant(dateTimeFormat.parseMillis(timestamp)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    static class RouteInfo {
        @Nullable
        @UnknownKeyFor @NonNull @Initialized String route;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized Double avgSpeed;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized Boolean slowdownEvent;

        public RouteInfo() {
        }

        public RouteInfo(@UnknownKeyFor @NonNull @Initialized String route, @UnknownKeyFor @NonNull @Initialized Double avgSpeed, @UnknownKeyFor @NonNull @Initialized Boolean slowdownEvent) {
            this.route = route;
            this.avgSpeed = avgSpeed;
            this.slowdownEvent = slowdownEvent;
        }

        public @UnknownKeyFor @NonNull @Initialized String getRoute() {
            return this.route;
        }

        public @UnknownKeyFor @NonNull @Initialized Double getAvgSpeed() {
            return this.avgSpeed;
        }

        public @UnknownKeyFor @NonNull @Initialized Boolean getSlowdownEvent() {
            return this.slowdownEvent;
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    static class StationSpeed
    implements Comparable<StationSpeed> {
        @Nullable
        @UnknownKeyFor @NonNull @Initialized String stationId;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized Double avgSpeed;
        @Nullable
        @UnknownKeyFor @NonNull @Initialized Long timestamp;

        public StationSpeed() {
        }

        public StationSpeed(@UnknownKeyFor @NonNull @Initialized String stationId, @UnknownKeyFor @NonNull @Initialized Double avgSpeed, @UnknownKeyFor @NonNull @Initialized Long timestamp) {
            this.stationId = stationId;
            this.avgSpeed = avgSpeed;
            this.timestamp = timestamp;
        }

        public @UnknownKeyFor @NonNull @Initialized String getStationId() {
            return this.stationId;
        }

        public @UnknownKeyFor @NonNull @Initialized Double getAvgSpeed() {
            return this.avgSpeed;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized StationSpeed other) {
            return Long.compare(this.timestamp, other.timestamp);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object object) {
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            StationSpeed otherStationSpeed = (StationSpeed)object;
            return Objects.equals(this.timestamp, otherStationSpeed.timestamp);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return this.timestamp.hashCode();
        }
    }
}

