/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.datatokenization.transforms;

import java.io.Serializable;
import org.apache.beam.examples.complete.datatokenization.DataTokenization;
import org.apache.beam.examples.complete.datatokenization.transforms.SerializableFunctions;
import org.apache.beam.examples.complete.datatokenization.utils.ErrorConverters;
import org.apache.beam.examples.complete.datatokenization.utils.FailsafeElement;
import org.apache.beam.examples.complete.datatokenization.utils.SchemasUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.JsonToRow;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JsonToBeamRow
extends PTransform<PCollection<String>, PCollection<Row>> {
    private final @UnknownKeyFor @NonNull @Initialized String failedToParseDeadLetterPath;
    private final transient @UnknownKeyFor @NonNull @Initialized SchemasUtils schema;

    public JsonToBeamRow(@UnknownKeyFor @NonNull @Initialized String failedToParseDeadLetterPath, @UnknownKeyFor @NonNull @Initialized SchemasUtils schema) {
        this.failedToParseDeadLetterPath = failedToParseDeadLetterPath;
        this.schema = schema;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> jsons) {
        JsonToRow.ParseResult rows = (JsonToRow.ParseResult)jsons.apply("JsonToRow", (PTransform)JsonToRow.withExceptionReporting((Schema)this.schema.getBeamSchema()).withExtendedErrorInfo());
        if (this.failedToParseDeadLetterPath != null) {
            ((PCollection)rows.getFailedToParseLines().apply("ToFailsafeElement", (PTransform)MapElements.into(DataTokenization.FAILSAFE_ELEMENT_CODER.getEncodedTypeDescriptor()).via((SerializableFunction & Serializable)errRow -> FailsafeElement.of(Strings.nullToEmpty((String)errRow.getString("line")), Strings.nullToEmpty((String)errRow.getString("line"))).setErrorMessage(Strings.nullToEmpty((String)errRow.getString("err")))))).apply("WriteCsvConversionErrorsToFS", ErrorConverters.WriteErrorsToTextIO.newBuilder().setErrorWritePath(this.failedToParseDeadLetterPath).setTranslateFunction(SerializableFunctions.getCsvErrorConverter()).build());
        }
        return rows.getResults().setRowSchema(this.schema.getBeamSchema());
    }
}

